/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes.traincarts;

import com.bergerkiller.bukkit.tc.TrainCarts;
import com.bergerkiller.bukkit.tc.properties.api.IProperty;
import com.bergerkiller.bukkit.tc.properties.api.IStringSetProperty;
import com.bergerkiller.bukkit.tc.signactions.SignAction;
import com.google.common.collect.Sets;
import gg.bundlegroup.scenes.Addon;
import gg.bundlegroup.scenes.api.Controller;
import gg.bundlegroup.scenes.api.Scenes;
import gg.bundlegroup.scenes.traincarts.SceneSetListener;
import gg.bundlegroup.scenes.traincarts.SceneSetProperty;
import gg.bundlegroup.scenes.traincarts.SignActionScene;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.jspecify.annotations.Nullable;

public class TrainCartsAddon
implements Addon {
    private final IStringSetProperty property = new SceneSetProperty(this);
    private final SignActionScene signAction = new SignActionScene(this.property);
    private final SceneSetListener listener = new SceneSetListener(this);
    private final Plugin plugin;
    private final Scenes scenes;
    private @Nullable Controller controller;

    public TrainCartsAddon(Plugin plugin, Scenes scenes) {
        this.plugin = plugin;
        this.scenes = scenes;
    }

    @Override
    public void load() {
        TrainCarts.plugin.getPropertyRegistry().register((IProperty)this.property);
        SignAction.register((SignAction)this.signAction);
    }

    @Override
    public void enable() {
        this.controller = this.scenes.createController(this.plugin);
        this.plugin.getServer().getPluginManager().registerEvents((Listener)this.listener, this.plugin);
    }

    @Override
    public void disable() {
        HandlerList.unregisterAll((Listener)this.listener);
        SignAction.unregister((SignAction)this.signAction);
        if (this.controller != null) {
            this.controller.close();
            this.controller = null;
        }
    }

    public IStringSetProperty getProperty() {
        return this.property;
    }

    public void applyScenes(Player player, Set<String> scenes) {
        if (this.controller == null) {
            return;
        }
        Set<String> shownTags = this.controller.getShownTags(player);
        for (String tag : Sets.difference(scenes, shownTags)) {
            this.controller.showTag(player, tag);
        }
        for (String tag : Sets.difference(shownTags, scenes)) {
            this.controller.hideTag(player, tag);
        }
    }
}

