/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes.traincarts;

import com.bergerkiller.bukkit.common.config.ConfigurationNode;
import com.bergerkiller.bukkit.common.entity.type.CommonMinecart;
import com.bergerkiller.bukkit.tc.Util;
import com.bergerkiller.bukkit.tc.properties.CartProperties;
import com.bergerkiller.bukkit.tc.properties.api.ICartProperty;
import com.bergerkiller.bukkit.tc.properties.api.IStringSetProperty;
import gg.bundlegroup.scenes.traincarts.TrainCartsAddon;
import java.util.Optional;
import java.util.Set;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

class SceneSetProperty
implements ICartProperty<Set<String>>,
IStringSetProperty {
    private static final String KEY = "scenesTags";
    private final TrainCartsAddon addon;

    SceneSetProperty(TrainCartsAddon addon) {
        this.addon = addon;
    }

    public Set<String> getDefault() {
        return Set.of();
    }

    public Optional<Set<String>> readFromConfig(ConfigurationNode config) {
        return Util.getConfigStringSetOptional((ConfigurationNode)config, (String)KEY);
    }

    public void writeToConfig(ConfigurationNode config, Optional<Set<String>> value) {
        Util.setConfigStringCollectionOptional((ConfigurationNode)config, (String)KEY, value);
    }

    public void set(CartProperties properties, Set<String> value) {
        super.set(properties, value);
        if (!properties.hasHolder()) {
            return;
        }
        for (Entity entity : ((CommonMinecart)properties.getHolder().getEntity()).getPassengers()) {
            if (!(entity instanceof Player)) continue;
            Player player = (Player)entity;
            this.addon.applyScenes(player, value);
        }
    }
}

