/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes.plugin;

import gg.bundlegroup.scenes.Addon;
import gg.bundlegroup.scenes.ScenesImpl;
import gg.bundlegroup.scenes.ScenesListener;
import gg.bundlegroup.scenes.api.Controller;
import gg.bundlegroup.scenes.api.ScenesProvider;
import gg.bundlegroup.scenes.entity.EntityListener;
import gg.bundlegroup.scenes.traincarts.TrainCartsAddon;
import gg.bundlegroup.scenes.worldedit.WorldEditAddonImpl;
import gg.bundlegroup.scenes.worldguard.worldguard.WorldGuardAddon;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.jspecify.annotations.Nullable;

public class Main
extends JavaPlugin {
    private final List<Addon> addons = new ArrayList<Addon>();
    private @Nullable ScenesImpl scenes;
    private @Nullable Controller manualController;

    public void onLoad() {
        this.scenes = new ScenesImpl((Plugin)this);
        ScenesProvider.setInstance(this.scenes);
        if (Bukkit.getPluginManager().getPlugin("Train_Carts") != null) {
            this.addons.add(new TrainCartsAddon((Plugin)this, this.scenes));
        }
        if (Bukkit.getPluginManager().getPlugin("WorldEdit") != null) {
            this.addons.add(new WorldEditAddonImpl((Plugin)this, this.scenes));
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            this.addons.add(new WorldGuardAddon((Plugin)this, this.scenes));
        }
        this.loadAddons();
    }

    public void onEnable() {
        if (this.scenes == null) {
            return;
        }
        this.manualController = this.scenes.createController((Plugin)this);
        this.enableAddons();
        PluginManager pluginManager = this.getServer().getPluginManager();
        pluginManager.registerEvents((Listener)new ScenesListener(this.scenes), (Plugin)this);
        pluginManager.registerEvents((Listener)new EntityListener(this.scenes.getEntityManager()), (Plugin)this);
        this.scenes.getEntityManager().refreshAllEntities();
    }

    public void onDisable() {
        if (this.scenes == null) {
            return;
        }
        if (this.manualController != null) {
            this.manualController.close();
            this.manualController = null;
        }
        this.disableAddons();
        this.addons.clear();
        this.scenes.close();
        this.scenes = null;
        ScenesProvider.setInstance(null);
    }

    public ScenesImpl getScenes() {
        return Objects.requireNonNull(this.scenes, "scenes");
    }

    public Controller getManualController() {
        return Objects.requireNonNull(this.manualController, "manualController");
    }

    private void loadAddons() {
        for (Addon addon : this.addons) {
            addon.load();
        }
    }

    private void enableAddons() {
        for (Addon addon : this.addons) {
            addon.enable();
        }
    }

    private void disableAddons() {
        for (Addon addon : this.addons) {
            addon.disable();
        }
    }

    public <T extends Addon> @Nullable T findAddon(Class<T> type) {
        for (Addon addon : this.addons) {
            if (!type.isInstance(addon)) continue;
            return (T)((Addon)type.cast(addon));
        }
        return null;
    }
}

