/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes.plugin;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import gg.bundlegroup.scenes.WorldEditAddon;
import gg.bundlegroup.scenes.command.HideCommand;
import gg.bundlegroup.scenes.command.ShowCommand;
import gg.bundlegroup.scenes.command.StatusCommand;
import gg.bundlegroup.scenes.command.suggestion.EntityTagSuggestionProvider;
import gg.bundlegroup.scenes.command.suggestion.HideTagSuggestionProvider;
import gg.bundlegroup.scenes.command.suggestion.ShowTagSuggestionProvider;
import gg.bundlegroup.scenes.command.suggestion.TagSuggestionProvider;
import gg.bundlegroup.scenes.command.tag.entity.EntityTagAddCommand;
import gg.bundlegroup.scenes.command.tag.entity.EntityTagRemoveCommand;
import gg.bundlegroup.scenes.command.tag.worldedit.WorldEditTagAddCommand;
import gg.bundlegroup.scenes.command.tag.worldedit.WorldEditTagRemoveCommand;
import gg.bundlegroup.scenes.plugin.Main;
import gg.bundlegroup.scenes.plugin.MainHolder;
import io.papermc.paper.command.brigadier.Commands;
import io.papermc.paper.command.brigadier.argument.ArgumentTypes;
import io.papermc.paper.plugin.bootstrap.BootstrapContext;
import io.papermc.paper.plugin.bootstrap.PluginBootstrap;
import io.papermc.paper.plugin.bootstrap.PluginProviderContext;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEventType;
import io.papermc.paper.plugin.lifecycle.event.types.LifecycleEvents;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

public class Bootstrap
implements PluginBootstrap {
    private final MainHolder mainHolder = new MainHolder();

    public void bootstrap(BootstrapContext context) {
        context.getLifecycleManager().registerEventHandler((LifecycleEventType)LifecycleEvents.COMMANDS, event -> this.registerCommands((Commands)event.registrar()));
    }

    private void registerCommands(Commands registrar) {
        registrar.register(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"scenes").requires(sender -> this.mainHolder.hasMain() && sender.getSender().hasPermission("scenes.use"))).then(((LiteralArgumentBuilder)Commands.literal((String)"status").requires(sender -> sender.getSender().hasPermission("scenes.status"))).executes((Command)new StatusCommand(this.mainHolder)))).then(((LiteralArgumentBuilder)Commands.literal((String)"show").requires(sender -> sender.getSender().hasPermission("scenes.manual"))).then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new ShowTagSuggestionProvider(this.mainHolder)).executes((Command)new ShowCommand(this.mainHolder))))).then(((LiteralArgumentBuilder)Commands.literal((String)"hide").requires(sender -> sender.getSender().hasPermission("scenes.manual"))).then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new HideTagSuggestionProvider(this.mainHolder)).executes((Command)new HideCommand(this.mainHolder))))).then(((LiteralArgumentBuilder)Commands.literal((String)"entity").requires(sender -> sender.getSender().hasPermission("scenes.assign.entity"))).then(Commands.argument((String)"entity", (ArgumentType)ArgumentTypes.entities()).then(((LiteralArgumentBuilder)Commands.literal((String)"tag").then(Commands.literal((String)"add").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new TagSuggestionProvider(this.mainHolder)).executes((Command)new EntityTagAddCommand(this.mainHolder))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new EntityTagSuggestionProvider(this.mainHolder)).executes((Command)new EntityTagRemoveCommand(this.mainHolder)))))))).then(((LiteralArgumentBuilder)Commands.literal((String)"worldedit").requires(sender -> this.mainHolder.getMain().findAddon(WorldEditAddon.class) != null && sender.getSender() instanceof Player && sender.getSender().hasPermission("scenes.assign.worldedit"))).then(((LiteralArgumentBuilder)Commands.literal((String)"tag").then(Commands.literal((String)"add").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new TagSuggestionProvider(this.mainHolder)).executes((Command)new WorldEditTagAddCommand(this.mainHolder))))).then(Commands.literal((String)"remove").then(Commands.argument((String)"tag", (ArgumentType)StringArgumentType.string()).suggests((SuggestionProvider)new TagSuggestionProvider(this.mainHolder)).executes((Command)new WorldEditTagRemoveCommand(this.mainHolder))))))).build());
    }

    public JavaPlugin createPlugin(PluginProviderContext context) {
        Main main = new Main();
        this.mainHolder.setMain(main);
        return main;
    }
}

