/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes.command.suggestion;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import gg.bundlegroup.scenes.ScenesImpl;
import gg.bundlegroup.scenes.plugin.MainHolder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.argument.resolvers.selector.EntitySelectorArgumentResolver;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.bukkit.entity.Entity;

public class EntityTagSuggestionProvider
implements SuggestionProvider<CommandSourceStack> {
    private final MainHolder mainHolder;

    public EntityTagSuggestionProvider(MainHolder mainHolder) {
        this.mainHolder = mainHolder;
    }

    public CompletableFuture<Suggestions> getSuggestions(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) throws CommandSyntaxException {
        EntitySelectorArgumentResolver entityResolver = (EntitySelectorArgumentResolver)context.getArgument("entity", EntitySelectorArgumentResolver.class);
        ScenesImpl scenes = this.mainHolder.getMain().getScenes();
        HashSet<String> tags = new HashSet<String>();
        for (Entity entity : (List)entityResolver.resolve((CommandSourceStack)context.getSource())) {
            tags.addAll(scenes.getEntityTags(entity));
        }
        for (String tag : tags) {
            builder.suggest(tag);
        }
        return builder.buildFuture();
    }
}

