/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import gg.bundlegroup.scenes.MessageStyle;
import gg.bundlegroup.scenes.api.Controller;
import gg.bundlegroup.scenes.plugin.Main;
import gg.bundlegroup.scenes.plugin.MainHolder;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.Style;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;

public class ShowCommand
implements Command<CommandSourceStack> {
    private final MainHolder mainHolder;

    public ShowCommand(MainHolder mainHolder) {
        this.mainHolder = mainHolder;
    }

    public int run(CommandContext<CommandSourceStack> context) {
        Entity entity = ((CommandSourceStack)context.getSource()).getExecutor();
        if (!(entity instanceof Player)) {
            return 0;
        }
        Player player = (Player)entity;
        String tag = (String)context.getArgument("tag", String.class);
        Main main = this.mainHolder.getMain();
        Controller manualController = main.getManualController();
        if (manualController.isShowingTag(player, tag)) {
            ((CommandSourceStack)context.getSource()).getSender().sendMessage(Component.text((String)"Already manually showing tag ", (Style)MessageStyle.ERROR).append((Component)Component.text((String)tag, (Style)MessageStyle.ERROR_ACCENT)));
            return 1;
        }
        manualController.showTag(player, tag);
        ((CommandSourceStack)context.getSource()).getSender().sendMessage(Component.text((String)"Manually showing tag ", (Style)MessageStyle.SUCCESS).append((Component)Component.text((String)tag, (Style)MessageStyle.SUCCESS_ACCENT)));
        return 1;
    }
}

