/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes;

import gg.bundlegroup.scenes.MultiMap;
import gg.bundlegroup.scenes.PluginController;
import gg.bundlegroup.scenes.PluginElement;
import gg.bundlegroup.scenes.api.Controller;
import gg.bundlegroup.scenes.api.Element;
import gg.bundlegroup.scenes.api.Scenes;
import gg.bundlegroup.scenes.api.Viewable;
import gg.bundlegroup.scenes.entity.EntityManager;
import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.kyori.adventure.key.Key;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class ScenesImpl
implements Scenes,
Closeable {
    private static final NamespacedKey TAGS_KEY = new NamespacedKey("scenes", "tags");
    private static final NamespacedKey LEGACY_TAGS_KEY = new NamespacedKey("bundlescenes", "tags");
    private static final NamespacedKey LEGACY_SCENE_KEY = new NamespacedKey("bundlescenes", "scene");
    private final Map<Plugin, PluginState> plugins = new HashMap<Plugin, PluginState>();
    private final Map<String, TagState> tags = new HashMap<String, TagState>();
    private final Map<PluginElement, ElementState> elements = new HashMap<PluginElement, ElementState>();
    private final Map<Player, PlayerState> players = new HashMap<Player, PlayerState>();
    private final EntityManager entityManager;

    public ScenesImpl(Plugin plugin) {
        this.entityManager = new EntityManager(plugin, this);
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public Controller createController(Plugin plugin) {
        PluginState pluginState = this.plugins.computeIfAbsent(plugin, PluginState::new);
        PluginController controller = new PluginController(this, plugin);
        pluginState.controllers.add(controller);
        return controller;
    }

    public void unregisterController(PluginController controller) {
        PluginState pluginState = this.plugins.get(controller.getPlugin());
        if (pluginState == null) {
            return;
        }
        pluginState.controllers.remove(controller);
        if (pluginState.isEmpty()) {
            this.plugins.remove(pluginState.plugin);
        }
    }

    @Override
    public Element createElement(Plugin plugin, Viewable viewable) {
        PluginState pluginState = this.plugins.computeIfAbsent(plugin, PluginState::new);
        PluginElement element = new PluginElement(this, plugin, viewable);
        pluginState.elements.add(element);
        return element;
    }

    @Override
    public Set<String> getTags() {
        return Set.copyOf(this.tags.keySet());
    }

    @Override
    public Set<String> getEntityTags(Entity entity) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        this.migrateData(pdc);
        List tags = (List)pdc.get(TAGS_KEY, (PersistentDataType)PersistentDataType.LIST.strings());
        if (tags == null) {
            return Set.of();
        }
        return Set.copyOf(tags);
    }

    @Override
    public void setEntityTags(Entity entity, Set<String> tags) {
        PersistentDataContainer pdc = entity.getPersistentDataContainer();
        if (tags.isEmpty()) {
            pdc.remove(TAGS_KEY);
        } else {
            pdc.set(TAGS_KEY, (PersistentDataType)PersistentDataType.LIST.strings(), List.copyOf(tags));
        }
        this.entityManager.refreshEntity(entity);
    }

    private void migrateData(PersistentDataContainer pdc) {
        List tags;
        if (pdc.has(LEGACY_SCENE_KEY, PersistentDataType.STRING)) {
            String prefix;
            String value;
            Key sceneKey;
            String scene = (String)pdc.get(LEGACY_SCENE_KEY, PersistentDataType.STRING);
            if (scene != null && Key.parseable((String)scene) && (sceneKey = Key.key((String)scene)).namespace().equals("bundlescenes") && (value = sceneKey.value()).startsWith(prefix = "worldguard/")) {
                String tag = value.substring(prefix.length());
                pdc.set(TAGS_KEY, (PersistentDataType)PersistentDataType.LIST.strings(), List.of(tag));
            }
            pdc.remove(LEGACY_SCENE_KEY);
        }
        if (pdc.has(LEGACY_TAGS_KEY, (PersistentDataType)PersistentDataType.LIST.strings()) && (tags = (List)pdc.get(LEGACY_TAGS_KEY, (PersistentDataType)PersistentDataType.LIST.strings())) != null) {
            pdc.set(TAGS_KEY, (PersistentDataType)PersistentDataType.LIST.strings(), (Object)tags);
            pdc.remove(LEGACY_TAGS_KEY);
        }
    }

    public void unregisterElement(PluginElement element) {
        PluginState pluginState = this.plugins.get(element.getPlugin());
        if (pluginState == null) {
            return;
        }
        pluginState.elements.remove(element);
        if (pluginState.isEmpty()) {
            this.plugins.remove(pluginState.plugin);
        }
    }

    public void addElementTag(PluginElement element, String tag) {
        ElementState elementState = this.elements.computeIfAbsent(element, ElementState::new);
        TagState tagState = this.tags.computeIfAbsent(tag, TagState::new);
        if (elementState.tags.add(tagState)) {
            tagState.elements.add(elementState);
            for (PlayerState playerState : tagState.viewers.keySet()) {
                elementState.viewers.addAndCheckFirst(playerState, tagState);
            }
        }
    }

    public void removeElementTag(PluginElement element, String tag) {
        ElementState elementState = this.elements.get(element);
        TagState tagState = this.tags.get(tag);
        if (elementState == null || tagState == null) {
            return;
        }
        if (elementState.tags.remove(tagState)) {
            tagState.elements.remove(elementState);
            for (PlayerState playerState : tagState.viewers.keySet()) {
                elementState.viewers.removeAndCheckLast(playerState, tagState);
            }
        }
        if (elementState.isEmpty()) {
            this.elements.remove(element);
        }
        if (tagState.isEmpty()) {
            this.tags.remove(tag);
        }
    }

    public void addPlayerTag(PluginController controller, Player player, String tag) {
        PlayerState playerState = this.players.computeIfAbsent(player, PlayerState::new);
        TagState tagState = this.tags.computeIfAbsent(tag, TagState::new);
        if (tagState.viewers.addAndCheckFirst(playerState, controller)) {
            playerState.tags.add(tagState);
            for (ElementState elementState : tagState.elements) {
                if (!elementState.viewers.addAndCheckFirst(playerState, tagState)) continue;
                elementState.element.getViewable().addViewer(player);
            }
        }
    }

    public void removePlayerTag(PluginController controller, Player player, String tag) {
        PlayerState playerState = this.players.get(player);
        TagState tagState = this.tags.get(tag);
        if (playerState == null || tagState == null) {
            return;
        }
        if (tagState.viewers.removeAndCheckLast(playerState, controller)) {
            playerState.tags.remove(tagState);
            for (ElementState elementState : tagState.elements) {
                if (!elementState.viewers.removeAndCheckLast(playerState, tagState)) continue;
                elementState.element.getViewable().removeViewer(player);
            }
        }
        if (playerState.isEmpty()) {
            this.players.remove(player);
        }
        if (tagState.isEmpty()) {
            this.tags.remove(tag);
        }
    }

    public void removePlayer(Player player) {
        PlayerState playerState = this.players.get(player);
        if (playerState == null) {
            return;
        }
        for (TagState tagState : playerState.tags) {
            for (PluginController controller : tagState.viewers.get(playerState)) {
                controller.removePlayer(player);
            }
            tagState.viewers.removeAll(playerState);
            for (ElementState elementState : tagState.elements) {
                if (!elementState.viewers.removeAndCheckLast(playerState, tagState)) continue;
                elementState.element.getViewable().removeViewer(player);
            }
            if (!tagState.isEmpty()) continue;
            this.tags.remove(tagState.tag);
        }
        this.players.remove(player);
    }

    @Override
    public void close() {
        for (PluginState pluginState : this.plugins.values()) {
            for (PluginElement element : pluginState.elements) {
                element.remove();
            }
            for (PluginController controller : pluginState.controllers) {
                controller.close();
            }
        }
        this.plugins.clear();
    }

    public void removePlugin(Plugin plugin) {
        PluginState pluginState = this.plugins.remove(plugin);
        if (pluginState == null) {
            return;
        }
        for (PluginElement element : pluginState.elements) {
            element.remove();
        }
        for (PluginController controller : pluginState.controllers) {
            controller.close();
        }
    }

    public int getTagCount() {
        return this.tags.size();
    }

    public int getElementCount() {
        return this.elements.size();
    }

    public int getPlayerCount() {
        return this.players.size();
    }

    private static class PluginState {
        private final Plugin plugin;
        private final Set<PluginController> controllers = new HashSet<PluginController>();
        private final Set<PluginElement> elements = new HashSet<PluginElement>();

        private PluginState(Plugin plugin) {
            this.plugin = plugin;
        }

        private boolean isEmpty() {
            return this.controllers.isEmpty() && this.elements.isEmpty();
        }
    }

    private static class ElementState {
        private final PluginElement element;
        private final Set<TagState> tags = new HashSet<TagState>();
        private final MultiMap<PlayerState, TagState> viewers = new MultiMap();

        private ElementState(PluginElement element) {
            this.element = element;
        }

        private boolean isEmpty() {
            return this.tags.isEmpty();
        }
    }

    private static class TagState {
        private final String tag;
        private final MultiMap<PlayerState, PluginController> viewers = new MultiMap();
        private final Set<ElementState> elements = new HashSet<ElementState>();

        private TagState(String tag) {
            this.tag = tag;
        }

        private boolean isEmpty() {
            return this.viewers.isEmpty() && this.elements.isEmpty();
        }
    }

    private static class PlayerState {
        private final Player player;
        private final Set<TagState> tags = new HashSet<TagState>();

        private PlayerState(Player player) {
            this.player = player;
        }

        private boolean isEmpty() {
            return this.tags.isEmpty();
        }
    }
}

