/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes;

import gg.bundlegroup.scenes.ScenesImpl;
import gg.bundlegroup.scenes.api.Element;
import gg.bundlegroup.scenes.api.Viewable;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.plugin.Plugin;

public class PluginElement
implements Element {
    private final ScenesImpl scenes;
    private final Plugin plugin;
    private final Viewable viewable;
    private final Set<String> tags = new HashSet<String>();

    public PluginElement(ScenesImpl scenes, Plugin plugin, Viewable viewable) {
        this.scenes = scenes;
        this.plugin = plugin;
        this.viewable = viewable;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public Viewable getViewable() {
        return this.viewable;
    }

    @Override
    public Set<String> getTags() {
        return Set.copyOf(this.tags);
    }

    @Override
    public void addTag(String tag) {
        if (this.tags.add(tag)) {
            this.doAddTag(tag);
        }
    }

    @Override
    public void removeTag(String tag) {
        if (this.tags.remove(tag)) {
            this.doRemoveTag(tag);
        }
    }

    private void doAddTag(String tag) {
        this.scenes.addElementTag(this, tag);
    }

    private void doRemoveTag(String tag) {
        this.scenes.removeElementTag(this, tag);
    }

    @Override
    public void remove() {
        this.tags.forEach(this::doRemoveTag);
        this.tags.clear();
        this.scenes.unregisterElement(this);
    }
}

