/*
 * Decompiled with CFR 0.152.
 */
package gg.bundlegroup.scenes;

import gg.bundlegroup.scenes.MultiMap;
import gg.bundlegroup.scenes.ScenesImpl;
import gg.bundlegroup.scenes.api.Controller;
import java.util.Set;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class PluginController
implements Controller {
    private final ScenesImpl scenes;
    private final Plugin plugin;
    private final MultiMap<Player, String> showingTags = new MultiMap();

    public PluginController(ScenesImpl scenes, Plugin plugin) {
        this.scenes = scenes;
        this.plugin = plugin;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    @Override
    public void showTag(Player player, String tag) {
        if (this.showingTags.add(player, tag)) {
            this.doShowTag(player, tag);
        }
    }

    @Override
    public void hideTag(Player player, String tag) {
        if (this.showingTags.remove(player, tag)) {
            this.doHideTag(player, tag);
        }
    }

    private void doShowTag(Player player, String tag) {
        this.scenes.addPlayerTag(this, player, tag);
    }

    private void doHideTag(Player player, String tag) {
        this.scenes.removePlayerTag(this, player, tag);
    }

    public void removePlayer(Player player) {
        this.showingTags.removeAll(player);
    }

    @Override
    public boolean isShowingTag(Player player, String tag) {
        return this.showingTags.contains(player, tag);
    }

    @Override
    public Set<String> getShownTags(Player player) {
        return Set.copyOf(this.showingTags.get(player));
    }

    @Override
    public void close() {
        this.showingTags.forEach(this::doHideTag);
        this.showingTags.clear();
        this.scenes.unregisterController(this);
    }
}

