/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.world;

import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import tk.bridgersilk.lesslag.LessLag;

public class WorldManager {
    private final LessLag plugin;
    private final Map<String, Long> worldActivity = new ConcurrentHashMap<String, Long>();

    public WorldManager(LessLag plugin) {
        this.plugin = plugin;
        for (World world : Bukkit.getWorlds()) {
            this.worldActivity.put(world.getName(), System.currentTimeMillis());
        }
        this.startAutoUnloadTask();
        this.startLowTpsUnloadTask();
        this.startActivityTracker();
    }

    private void startActivityTracker() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            for (World world : Bukkit.getWorlds()) {
                if (world.getPlayers().isEmpty()) continue;
                this.worldActivity.put(world.getName(), System.currentTimeMillis());
            }
        }, 20L, 20L);
    }

    private void startAutoUnloadTask() {
        if (!this.plugin.getConfig().getBoolean("world_management.auto_unload.enabled")) {
            return;
        }
        long checkInterval = this.plugin.getConfig().getLong("settings.tps_check_interval", 20L);
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            int inactivityMinutes = this.plugin.getConfig().getInt("world_management.auto_unload.inactivity_minutes", 5);
            long inactivityThreshold = (long)inactivityMinutes * 60000L;
            List excluded = this.plugin.getConfig().getStringList("world_management.auto_unload.excluded_worlds");
            for (World world : Bukkit.getWorlds()) {
                if (excluded.contains(world.getName())) continue;
                Long lastActive = this.worldActivity.getOrDefault(world.getName(), System.currentTimeMillis());
                if (System.currentTimeMillis() - lastActive < inactivityThreshold || !world.getPlayers().isEmpty()) continue;
                this.unloadWorld(world, "auto-unload (inactive)");
            }
        }, checkInterval, checkInterval);
    }

    private void startLowTpsUnloadTask() {
        if (!this.plugin.getConfig().getBoolean("world_management.force_unload_on_low_tps.enabled")) {
            return;
        }
        long checkInterval = this.plugin.getConfig().getLong("settings.tps_check_interval", 20L);
        String prefix = this.plugin.getConfig().getString("settings.prefix");
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            double criticalTps = this.plugin.getConfig().getDouble("settings.critical_tps_threshold", 10.0);
            double currentTps = Bukkit.getServer().getTPS()[0];
            if (currentTps < criticalTps) {
                String transferWorldName = this.plugin.getConfig().getString("world_management.force_unload_on_low_tps.player_transfer_world", "world");
                World transferWorld = Bukkit.getWorld((String)transferWorldName);
                if (transferWorld == null) {
                    this.plugin.getLogger().warning("Transfer world '" + transferWorldName + "' not found. Skipping unload.");
                    return;
                }
                for (World world : Bukkit.getWorlds()) {
                    if (world.getName().equalsIgnoreCase(transferWorldName)) continue;
                    for (Player p : world.getPlayers()) {
                        p.teleport(transferWorld.getSpawnLocation());
                        p.sendMessage(prefix + "\u00a7cServer lag detected. You have been moved to \u00a7b" + transferWorld.getName());
                    }
                    this.unloadWorld(world, "low TPS emergency");
                }
            }
        }, checkInterval, checkInterval);
    }

    private void unloadWorld(World world, String reason) {
        int entities = world.getEntities().size();
        int chunks = world.getLoadedChunks().length;
        int players = world.getPlayers().size();
        double sizeMb = this.getWorldSizeInMb(world);
        String prefix = this.plugin.getConfig().getString("settings.prefix");
        String message = String.format("\u00a7b%s \u00a77| Entities: \u00a7f%d \u00a77| Chunks: \u00a7f%d \u00a77| Players: \u00a7f%d \u00a77| Size: \u00a7f%.2f MB", world.getName(), entities, chunks, players, sizeMb);
        boolean saveWorld = this.plugin.getConfig().getBoolean("world_management.auto_unload.save_world");
        boolean success = Bukkit.unloadWorld((World)world, (boolean)saveWorld);
        if (success) {
            for (Player admin : Bukkit.getOnlinePlayers()) {
                if (!admin.hasPermission("lesslag.admin")) continue;
                admin.sendMessage(prefix + "\u00a7eUnloaded world: " + message + " \u00a77(Reason: " + reason + ")");
            }
        }
    }

    private double getWorldSizeInMb(World world) {
        File folder = world.getWorldFolder();
        return this.bytesToMb(this.getFolderSize(folder));
    }

    private long getFolderSize(File folder) {
        if (!folder.exists()) {
            return 0L;
        }
        if (folder.isFile()) {
            return folder.length();
        }
        long length = 0L;
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                length += this.getFolderSize(file);
                ++n2;
            }
        }
        return length;
    }

    private double bytesToMb(long bytes) {
        return (double)bytes / 1024.0 / 1024.0;
    }

    public void disable() {
        Bukkit.getScheduler().cancelTasks((Plugin)this.plugin);
        this.worldActivity.clear();
    }
}

