/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.system;

import java.io.File;
import java.text.DecimalFormat;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import tk.bridgersilk.lesslag.LessLag;

public class WorldInfo {
    private final DecimalFormat df = new DecimalFormat("#.##");
    private final FileConfiguration config;

    public WorldInfo(LessLag plugin) {
        this.config = plugin.getConfig();
    }

    public void sendWorldInfo(CommandSender sender) {
        String prefix = this.config.getString("settings.prefix");
        sender.sendMessage(prefix + "\u00a7e--- World Information ---");
        for (World world : Bukkit.getWorlds()) {
            String worldName = world.getName();
            int entityCount = world.getEntities().size();
            int loadedChunks = world.getLoadedChunks().length;
            int players = world.getPlayers().size();
            double fileSizeMB = (double)this.getWorldFolderSize(world.getWorldFolder()) / 1024.0 / 1024.0;
            sender.sendMessage(prefix + String.format("\u00a7b%s \u00a77| Entities: \u00a7f%d \u00a77| Chunks: \u00a7f%d \u00a77| Players: \u00a7f%d \u00a77| Size: \u00a7f%s MB", worldName, entityCount, loadedChunks, players, this.df.format(fileSizeMB)));
        }
    }

    private long getWorldFolderSize(File folder) {
        long length = 0L;
        File[] files = folder.listFiles();
        if (files != null) {
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                length = file.isFile() ? (length += file.length()) : (length += this.getWorldFolderSize(file));
                ++n2;
            }
        }
        return length;
    }
}

