/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.system;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.boss.BarColor;
import org.bukkit.boss.BarFlag;
import org.bukkit.boss.BarStyle;
import org.bukkit.boss.BossBar;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import tk.bridgersilk.lesslag.LessLag;

public class Profiler {
    private final LessLag plugin;
    private final BossBar bossBar;
    private final Set<Player> viewers;
    private final FileConfiguration config;
    private long totalIncomingPackets = 0L;
    private long totalOutgoingPackets = 0L;
    private boolean blinkToggle = false;
    private final boolean enabled;
    private final int updateIntervalTicks;
    private final boolean showCPU;
    private final boolean showRAM;
    private final boolean showPackets;

    public Profiler(LessLag plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.enabled = this.config.getBoolean("profiler.enabled", true);
        this.updateIntervalTicks = this.config.getInt("profiler.update_interval_ticks", 20);
        this.showCPU = this.config.getBoolean("profiler.show_cpu_usage", true);
        this.showRAM = this.config.getBoolean("profiler.show_ram_usage", true);
        this.showPackets = this.config.getBoolean("profiler.show_packets", true);
        this.bossBar = Bukkit.createBossBar((String)"\u00a7eProfiler", (BarColor)BarColor.BLUE, (BarStyle)BarStyle.SEGMENTED_10, (BarFlag[])new BarFlag[0]);
        this.viewers = new HashSet<Player>();
        if (this.enabled) {
            this.registerPacketListeners();
            this.startUpdating();
        }
    }

    private PacketType[] getClientPackets() {
        return new PacketType[]{PacketType.Play.Client.POSITION, PacketType.Play.Client.POSITION_LOOK, PacketType.Play.Client.LOOK, PacketType.Play.Client.KEEP_ALIVE, PacketType.Play.Client.ENTITY_ACTION, PacketType.Play.Client.CHAT, PacketType.Play.Client.USE_ENTITY, PacketType.Play.Client.BLOCK_DIG, PacketType.Play.Client.ARM_ANIMATION, PacketType.Play.Client.HELD_ITEM_SLOT, PacketType.Play.Client.WINDOW_CLICK, PacketType.Play.Client.CLIENT_COMMAND, PacketType.Play.Client.TAB_COMPLETE, PacketType.Play.Client.VEHICLE_MOVE, PacketType.Play.Client.CLOSE_WINDOW, PacketType.Play.Client.CUSTOM_PAYLOAD, PacketType.Play.Client.ABILITIES, PacketType.Play.Client.ADVANCEMENTS, PacketType.Play.Client.BEACON, PacketType.Play.Client.BOAT_MOVE, PacketType.Play.Client.GROUND, PacketType.Play.Client.PICK_ITEM};
    }

    private PacketType[] getServerPackets() {
        return new PacketType[]{PacketType.Play.Server.CHAT, PacketType.Play.Server.ENTITY_VELOCITY, PacketType.Play.Server.ENTITY_TELEPORT, PacketType.Play.Server.WINDOW_ITEMS, PacketType.Play.Server.SET_SLOT, PacketType.Play.Server.PLAYER_INFO, PacketType.Play.Server.KEEP_ALIVE, PacketType.Play.Server.SPAWN_ENTITY, PacketType.Play.Server.BLOCK_CHANGE, PacketType.Play.Server.MULTI_BLOCK_CHANGE, PacketType.Play.Server.CUSTOM_PAYLOAD, PacketType.Play.Server.EXPLOSION, PacketType.Play.Server.OPEN_WINDOW, PacketType.Play.Server.BOSS, PacketType.Play.Server.AUTO_RECIPE, PacketType.Play.Server.COLLECT, PacketType.Play.Server.COMMANDS, PacketType.Play.Server.DAMAGE_EVENT, PacketType.Play.Server.ENTITY_DESTROY, PacketType.Play.Server.ENTITY_LOOK, PacketType.Play.Server.ENTITY_VELOCITY, PacketType.Play.Server.BLOCK_ACTION, PacketType.Play.Server.POSITION};
    }

    private void registerPacketListeners() {
        if (!this.showPackets) {
            return;
        }
        ProtocolManager manager = ProtocolLibrary.getProtocolManager();
        manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, this.getClientPackets()){

            public void onPacketReceiving(PacketEvent event) {
                ++Profiler.this.totalIncomingPackets;
            }
        });
        manager.addPacketListener((PacketListener)new PacketAdapter((Plugin)this.plugin, this.getServerPackets()){

            public void onPacketSending(PacketEvent event) {
                ++Profiler.this.totalOutgoingPackets;
            }
        });
    }

    private void startUpdating() {
        Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            this.blinkToggle = !this.blinkToggle;
            double tps = Bukkit.getServer().getTPS()[0];
            double mspt = Bukkit.getAverageTickTime();
            OperatingSystemMXBean osBean = ManagementFactory.getOperatingSystemMXBean();
            double cpuLoad = this.showCPU ? osBean.getSystemLoadAverage() / (double)osBean.getAvailableProcessors() * 10.0 : 0.0;
            long usedMem = this.showRAM ? (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L : 0L;
            long maxMem = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
            for (Player player : this.viewers) {
                boolean highTps;
                int ping = this.getPing(player);
                boolean criticalCpu = cpuLoad > 90.0;
                boolean highCpu = cpuLoad > 70.0;
                boolean criticalRam = (double)usedMem > (double)maxMem * 0.9;
                boolean highRam = (double)usedMem > (double)maxMem * 0.75;
                boolean criticalTps = tps < 10.0;
                boolean bl = highTps = tps < 15.0;
                BarColor color = this.showCPU && (criticalCpu || highCpu) || this.showRAM && (criticalRam || highRam) || criticalTps ? (criticalCpu || criticalRam || criticalTps ? (this.blinkToggle ? BarColor.RED : BarColor.PINK) : BarColor.YELLOW) : BarColor.BLUE;
                StringBuilder title = new StringBuilder();
                title.append("\u00a7bTPS: ").append(this.colorString(tps, highTps, criticalTps)).append(String.format("%.2f", tps));
                title.append(" \u00a77| \u00a7bMSPT: ").append(this.colorString(mspt, highTps, criticalTps)).append(String.format("%.2f", mspt));
                if (this.showCPU) {
                    title.append(" \u00a77| \u00a7bCPU: ").append(this.colorString(cpuLoad, highCpu, criticalCpu)).append(String.format("%.0f%%", cpuLoad));
                }
                if (this.showRAM) {
                    title.append(" \u00a77| \u00a7bRAM: ").append(this.colorString(usedMem, highRam, criticalRam)).append(String.format("%d/%d MB", usedMem, maxMem));
                }
                title.append(" \u00a77| \u00a7bPing: \u00a7f").append(ping).append("ms");
                if (this.showPackets) {
                    title.append(" \u00a77| \u00a7bPackets In: \u00a7f").append(this.totalIncomingPackets).append(" \u00a77| \u00a7bPackets Out: \u00a7f").append(this.totalOutgoingPackets);
                }
                this.bossBar.setTitle(title.toString());
                this.bossBar.setColor(color);
            }
        }, (long)this.updateIntervalTicks, (long)this.updateIntervalTicks);
    }

    private int getPing(Player player) {
        try {
            return player.getPing();
        }
        catch (NoSuchMethodError e) {
            return 0;
        }
    }

    private String colorString(double value, boolean isHigh, boolean isCritical) {
        if (isCritical) {
            return "\u00a7c";
        }
        if (isHigh) {
            return "\u00a7e";
        }
        return "\u00a7f";
    }

    public void toggleProfiler(CommandSender sender) {
        String prefix = this.config.getString("settings.prefix");
        if (!(sender instanceof Player)) {
            sender.sendMessage(prefix + "\u00a7cOnly players can view the profiler.");
            return;
        }
        Player player = (Player)sender;
        if (this.viewers.contains(player)) {
            this.bossBar.removePlayer(player);
            this.viewers.remove(player);
            player.sendMessage(prefix + "\u00a7cProfiler disabled.");
        } else {
            this.bossBar.addPlayer(player);
            this.viewers.add(player);
            player.sendMessage(prefix + "\u00a7aProfiler enabled.");
        }
    }

    public void disable() {
        for (Player player : this.viewers) {
            this.bossBar.removePlayer(player);
        }
        this.viewers.clear();
        Bukkit.getScheduler().cancelTasks((Plugin)this.plugin);
        ProtocolLibrary.getProtocolManager().getPacketListeners().stream().filter(listener -> listener.getPlugin().equals((Object)this.plugin)).forEach(arg_0 -> ((ProtocolManager)ProtocolLibrary.getProtocolManager()).removePacketListener(arg_0));
        this.totalIncomingPackets = 0L;
        this.totalOutgoingPackets = 0L;
    }
}

