/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.player;

import com.comphenix.protocol.PacketType;
import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import com.comphenix.protocol.events.ListenerPriority;
import com.comphenix.protocol.events.PacketAdapter;
import com.comphenix.protocol.events.PacketEvent;
import com.comphenix.protocol.events.PacketListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public class PlayerManager {
    private final Plugin plugin;
    private final ProtocolManager protocolManager;
    private PacketAdapter packetListener;
    private int maxPlayersPerWorld;
    private String fallbackWorldName;
    private boolean packetSpamEnabled;
    private int packetLimit;
    private String packetAction;
    private String packetActionReason;
    private boolean chatSpamEnabled;
    private int maxMessagesPerSecond;
    private int muteDurationSeconds;
    private final Map<Player, Integer> packetCounts = new ConcurrentHashMap<Player, Integer>();
    private final Map<UUID, Integer> playerMessageCounts = new ConcurrentHashMap<UUID, Integer>();
    private int totalMessagesPerSecond = 0;
    private boolean chatMuted = false;
    public long chatMutedUntil = 0L;
    private BukkitTask scheduledTask;

    public PlayerManager(Plugin plugin) {
        this.plugin = plugin;
        this.protocolManager = ProtocolLibrary.getProtocolManager();
        this.reloadConfig();
        this.startScheduledTasks();
        this.registerPacketListener();
    }

    public void reloadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.maxPlayersPerWorld = config.getInt("player_management.max_players_per_world");
        this.fallbackWorldName = config.getString("player_management.fallback_world", "lobby");
        this.packetSpamEnabled = config.getBoolean("player_management.packet_spam_protection.enabled", true);
        this.packetLimit = config.getInt("player_management.packet_spam_protection.packet_limit", 1000);
        this.packetAction = config.getString("player_management.packet_spam_protection.action", "kick");
        this.packetActionReason = config.getString("player_management.packet_spam_protection.action_reason", "\u00a7cYou're sending way too many packets! Trying to crash the server!?");
        this.chatSpamEnabled = config.getBoolean("player_management.chat_spam_protection.enabled", true);
        this.maxMessagesPerSecond = config.getInt("player_management.chat_spam_protection.max_messages_per_second", 6);
        this.muteDurationSeconds = config.getInt("player_management.chat_spam_protection.mute_duration_seconds", 5);
    }

    private void startScheduledTasks() {
        this.scheduledTask = new BukkitRunnable(){

            public void run() {
                PlayerManager.this.handleWorldPlayerLimits();
                PlayerManager.this.handlePacketSpam();
                PlayerManager.this.handleChatSpamReset();
            }
        }.runTaskTimer(this.plugin, 20L, 20L);
    }

    private void registerPacketListener() {
        if (this.packetListener != null) {
            this.protocolManager.removePacketListener((PacketListener)this.packetListener);
        }
        this.packetListener = new PacketAdapter(this.plugin, ListenerPriority.NORMAL, new PacketType[]{PacketType.Play.Client.POSITION, PacketType.Play.Client.POSITION_LOOK, PacketType.Play.Client.LOOK, PacketType.Play.Client.KEEP_ALIVE, PacketType.Play.Client.ENTITY_ACTION, PacketType.Play.Client.CHAT, PacketType.Play.Client.USE_ENTITY, PacketType.Play.Client.BLOCK_DIG, PacketType.Play.Client.ARM_ANIMATION, PacketType.Play.Client.HELD_ITEM_SLOT, PacketType.Play.Client.WINDOW_CLICK, PacketType.Play.Client.CLIENT_COMMAND, PacketType.Play.Client.TAB_COMPLETE, PacketType.Play.Client.VEHICLE_MOVE, PacketType.Play.Client.CLOSE_WINDOW, PacketType.Play.Client.ABILITIES, PacketType.Play.Client.ADVANCEMENTS, PacketType.Play.Client.BEACON, PacketType.Play.Client.BOAT_MOVE, PacketType.Play.Client.CUSTOM_PAYLOAD, PacketType.Play.Client.GROUND, PacketType.Play.Client.PICK_ITEM}){

            public void onPacketReceiving(PacketEvent event) {
                if (!PlayerManager.this.packetSpamEnabled) {
                    return;
                }
                Player player = event.getPlayer();
                PlayerManager.this.packetCounts.put(player, PlayerManager.this.packetCounts.getOrDefault(player, 0) + 1);
            }

            public void onPacketSending(PacketEvent event) {
            }
        };
        this.protocolManager.addPacketListener((PacketListener)this.packetListener);
    }

    public void disable() {
        if (this.scheduledTask != null) {
            this.scheduledTask.cancel();
        }
        if (this.packetListener != null) {
            this.protocolManager.removePacketListener((PacketListener)this.packetListener);
        }
    }

    private void handleWorldPlayerLimits() {
        String prefix = this.plugin.getConfig().getString("settings.prefix");
        for (World world : Bukkit.getWorlds()) {
            int playerCount;
            if (world.getName().equalsIgnoreCase(this.fallbackWorldName) || (playerCount = world.getPlayers().size()) <= this.maxPlayersPerWorld) continue;
            int excess = playerCount - this.maxPlayersPerWorld;
            ArrayList players = new ArrayList(world.getPlayers());
            Collections.shuffle(players);
            World fallback = Bukkit.getWorld((String)this.fallbackWorldName);
            if (fallback == null) continue;
            int i = 0;
            while (i < excess) {
                Player p = (Player)players.get(i);
                p.teleport(fallback.getSpawnLocation());
                p.sendMessage(prefix + "\u00a7cThe world was over capacity. You've been moved to the fallback world.");
                ++i;
            }
        }
    }

    private void handlePacketSpam() {
        if (!this.packetSpamEnabled) {
            return;
        }
        for (Map.Entry<Player, Integer> entry : this.packetCounts.entrySet()) {
            Player player = entry.getKey();
            int packets = entry.getValue();
            if (packets <= this.packetLimit) continue;
            if (this.packetAction.equalsIgnoreCase("kick")) {
                player.kickPlayer(this.packetActionReason);
            } else if (this.packetAction.equalsIgnoreCase("ban")) {
                player.banPlayer(this.packetActionReason);
            }
            this.notifyAdmins(player.getName(), packets);
        }
        this.packetCounts.clear();
    }

    private void notifyAdmins(String playerName, int packets) {
        String prefix = this.plugin.getConfig().getString("settings.prefix");
        String action = this.packetAction.equalsIgnoreCase("kick") ? "kicked" : "banned";
        for (Player p : Bukkit.getOnlinePlayers()) {
            if (!p.hasPermission("lesslag.admin")) continue;
            p.sendMessage(prefix + "\u00a7ePlayer Packet Limit: \u00a7b" + playerName + " \u00a7cgot \u00a7b" + action + " \u00a7cfor sending too many packets. \u00a77(" + packets + " packets/second)");
        }
    }

    public boolean isChatMuted() {
        return this.chatMuted && System.currentTimeMillis() < this.chatMutedUntil;
    }

    public void incrementMessageCount(Player player) {
        this.playerMessageCounts.put(player.getUniqueId(), this.playerMessageCounts.getOrDefault(player.getUniqueId(), 0) + 1);
        ++this.totalMessagesPerSecond;
        if (this.chatSpamEnabled && this.totalMessagesPerSecond > this.maxMessagesPerSecond && !this.chatMuted) {
            this.chatMuted = true;
            this.chatMutedUntil = System.currentTimeMillis() + (long)this.muteDurationSeconds * 1000L;
            String prefix = this.plugin.getConfig().getString("settings.prefix");
            for (Player p : Bukkit.getOnlinePlayers()) {
                if (!p.hasPermission("lesslag.admin")) continue;
                p.sendMessage(prefix + "\u00a7cChat has been muted for \u00a7b" + this.muteDurationSeconds + "s \u00a7cdue to spam.");
            }
        }
    }

    private void handleChatSpamReset() {
        this.playerMessageCounts.clear();
        this.totalMessagesPerSecond = 0;
        if (this.chatMuted && System.currentTimeMillis() >= this.chatMutedUntil) {
            this.chatMuted = false;
            String prefix = this.plugin.getConfig().getString("settings.prefix");
            Bukkit.broadcastMessage((String)(prefix + "\u00a7aChat has been unmuted."));
        }
    }

    public int getMaxPlayersPerWorld() {
        return this.maxPlayersPerWorld;
    }

    public String getFallbackWorldName() {
        return this.fallbackWorldName;
    }
}

