/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.performance;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.GameRule;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TickSpeedListener {
    private final Plugin plugin;
    private final FileConfiguration config;
    private final double tpsThreshold;
    private final double decreaseTo;
    private boolean changeTickSpeed;
    private Map<World, Integer> tickSpeedMap;

    public TickSpeedListener(Plugin plugin, int decreaseTo, double tpsThreshold) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.tpsThreshold = tpsThreshold;
        this.decreaseTo = decreaseTo;
        this.changeTickSpeed = false;
        this.tickSpeedMap = new HashMap<World, Integer>();
        this.startTask();
    }

    private void startTask() {
        new BukkitRunnable(){

            public void run() {
                if (!TickSpeedListener.this.config.getBoolean("performance_controls.decrease_tickspeed.enabled")) {
                    return;
                }
                double tps = Bukkit.getServer().getTPS()[0];
                if (tps < TickSpeedListener.this.tpsThreshold) {
                    if (!TickSpeedListener.this.changeTickSpeed) {
                        TickSpeedListener.this.tickSpeedMap.clear();
                        for (World world : Bukkit.getWorlds()) {
                            Integer current = (Integer)world.getGameRuleValue(GameRule.RANDOM_TICK_SPEED);
                            if (current == null) {
                                Integer def = (Integer)world.getGameRuleDefault(GameRule.RANDOM_TICK_SPEED);
                                current = def != null ? def : 3;
                            }
                            TickSpeedListener.this.tickSpeedMap.put(world, current);
                            world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)((int)TickSpeedListener.this.decreaseTo));
                        }
                        TickSpeedListener.this.changeTickSpeed = true;
                    }
                } else if (TickSpeedListener.this.changeTickSpeed) {
                    for (World world : Bukkit.getWorlds()) {
                        Integer original = TickSpeedListener.this.tickSpeedMap.get(world);
                        if (original == null) {
                            Integer def = (Integer)world.getGameRuleDefault(GameRule.RANDOM_TICK_SPEED);
                            original = def != null ? def : 3;
                        }
                        world.setGameRule(GameRule.RANDOM_TICK_SPEED, (Object)original);
                    }
                    TickSpeedListener.this.changeTickSpeed = false;
                }
            }
        }.runTaskTimer(this.plugin, 100L, 100L);
    }
}

