/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.performance;

import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;
import tk.bridgersilk.lesslag.performance.CommandBlockListener;
import tk.bridgersilk.lesslag.performance.EnderPearlListener;
import tk.bridgersilk.lesslag.performance.ExplosionListener;
import tk.bridgersilk.lesslag.performance.FallingBlockListener;
import tk.bridgersilk.lesslag.performance.FluidListener;
import tk.bridgersilk.lesslag.performance.MobAIListener;
import tk.bridgersilk.lesslag.performance.RedstoneListener;
import tk.bridgersilk.lesslag.performance.TickSpeedListener;

public class PerformanceManager {
    private final Plugin plugin;
    private boolean redstoneEnabled;
    private boolean redstoneClocksOnly;
    private double redstoneTpsThreshold;
    private boolean fallingBlocksEnabled;
    private double fallingBlocksTpsThreshold;
    private boolean fluidsEnabled;
    private double fluidsTpsThreshold;
    private boolean explosionsEnabled;
    private double explosionsTpsThreshold;
    private boolean enderPearlsEnabled;
    private double enderPearlsTpsThreshold;
    private boolean commandBlocksEnabled;
    private double commandBlocksTpsThreshold;
    private boolean mobAiDisableWhenNoPlayers;
    private int mobAiRadius;
    private boolean decreaseTickSpeed;
    private double tickSpeedThreshold;
    private int decreaseTickSpeedTo;
    private RedstoneListener redstoneListener;
    private FallingBlockListener fallingBlockListener;
    private FluidListener fluidListener;
    private ExplosionListener explosionListener;
    private EnderPearlListener enderPearlListener;
    private CommandBlockListener commandBlockListener;
    private MobAIListener mobAIListener;
    private TickSpeedListener tickSpeedListener;
    private BukkitTask aiCheckTask;

    public PerformanceManager(Plugin plugin) {
        this.plugin = plugin;
        this.reloadConfig();
        this.registerListeners();
    }

    public void reloadConfig() {
        FileConfiguration config = this.plugin.getConfig();
        this.redstoneEnabled = config.getBoolean("performance_controls.disable_redstone.enabled");
        this.redstoneClocksOnly = config.getBoolean("performance_controls.disable_redstone.clocks_only");
        this.redstoneTpsThreshold = config.getDouble("performance_controls.disable_redstone.disable_below_tps");
        this.fallingBlocksEnabled = config.getBoolean("performance_controls.disable_falling_blocks.enabled");
        this.fallingBlocksTpsThreshold = config.getDouble("performance_controls.disable_falling_blocks.disable_below_tps");
        this.fluidsEnabled = config.getBoolean("performance_controls.disable_fluids.enabled");
        this.fluidsTpsThreshold = config.getDouble("performance_controls.disable_fluids.disable_below_tps");
        this.explosionsEnabled = config.getBoolean("performance_controls.disable_explosions.enabled");
        this.explosionsTpsThreshold = config.getDouble("performance_controls.disable_explosions.disable_below_tps");
        this.enderPearlsEnabled = config.getBoolean("performance_controls.disable_ender_pearls.enabled");
        this.enderPearlsTpsThreshold = config.getDouble("performance_controls.disable_ender_pearls.disable_below_tps");
        this.commandBlocksEnabled = config.getBoolean("performance_controls.disable_command_blocks.enabled");
        this.commandBlocksTpsThreshold = config.getDouble("performance_controls.disable_command_blocks.disable_below_tps");
        this.mobAiDisableWhenNoPlayers = config.getBoolean("mob_ai.disable_ai_when_no_players_nearby.enabled");
        this.mobAiRadius = config.getInt("mob_ai.disable_ai_when_no_players_nearby.radius");
        this.decreaseTickSpeed = config.getBoolean("performance_controls.decrease_tickspeed.enabled");
        this.decreaseTickSpeedTo = config.getInt("performance_controls.decrease_tickspeed.decrease_to");
        this.tickSpeedThreshold = config.getDouble("performance_controls.decrease_tickspeed.decrease_below_tps");
    }

    private void registerListeners() {
        if (this.redstoneEnabled) {
            this.redstoneListener = new RedstoneListener(this.plugin, this.redstoneClocksOnly, this.redstoneTpsThreshold);
        }
        if (this.fallingBlocksEnabled) {
            this.fallingBlockListener = new FallingBlockListener(this.plugin, this.fallingBlocksTpsThreshold);
        }
        if (this.fluidsEnabled) {
            this.fluidListener = new FluidListener(this.plugin, this.fluidsTpsThreshold);
        }
        if (this.explosionsEnabled) {
            this.explosionListener = new ExplosionListener(this.plugin, this.explosionsTpsThreshold);
        }
        if (this.enderPearlsEnabled) {
            this.enderPearlListener = new EnderPearlListener(this.plugin, this.enderPearlsTpsThreshold);
        }
        if (this.commandBlocksEnabled) {
            this.commandBlockListener = new CommandBlockListener(this.plugin, this.commandBlocksTpsThreshold);
        }
        if (this.mobAiDisableWhenNoPlayers) {
            this.mobAIListener = new MobAIListener(this.plugin, this.mobAiRadius);
        }
        if (this.decreaseTickSpeed) {
            this.tickSpeedListener = new TickSpeedListener(this.plugin, this.decreaseTickSpeedTo, this.tickSpeedThreshold);
        }
    }

    public void disable() {
        if (this.redstoneListener != null) {
            this.redstoneListener.unregister();
        }
        if (this.fallingBlockListener != null) {
            this.fallingBlockListener.unregister();
        }
        if (this.fluidListener != null) {
            this.fluidListener.unregister();
        }
        if (this.explosionListener != null) {
            this.explosionListener.unregister();
        }
        if (this.enderPearlListener != null) {
            this.enderPearlListener.unregister();
        }
        if (this.commandBlockListener != null) {
            this.commandBlockListener.unregister();
        }
        if (this.mobAIListener != null) {
            this.mobAIListener.unregister();
        }
        if (this.aiCheckTask != null) {
            this.aiCheckTask.cancel();
        }
    }
}

