/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.performance;

import org.bukkit.Bukkit;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.CreatureSpawnEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class MobAIListener
implements Listener {
    private final Plugin plugin;
    private final FileConfiguration config;
    private final int mobAiRadius;

    public MobAIListener(Plugin plugin, int mobAiRadius) {
        this.plugin = plugin;
        this.mobAiRadius = mobAiRadius;
        this.config = plugin.getConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        this.startTask();
    }

    private void startTask() {
        new BukkitRunnable(){

            public void run() {
                if (!MobAIListener.this.config.getBoolean("mob_ai.disable_ai_when_no_players_nearby.enabled")) {
                    return;
                }
                for (Entity entity : Bukkit.getWorlds().stream().flatMap(w -> w.getEntities().stream()).toList()) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity mob = (LivingEntity)entity;
                    boolean hasNearby = mob.getNearbyEntities((double)MobAIListener.this.mobAiRadius, (double)MobAIListener.this.mobAiRadius, (double)MobAIListener.this.mobAiRadius).stream().anyMatch(e -> e instanceof Player);
                    mob.setAI(hasNearby);
                    if (MobAIListener.this.config.getBoolean("mob_ai.disable_ai_when_no_players_nearby.invulnerable")) continue;
                    mob.setInvulnerable(!hasNearby);
                }
            }
        }.runTaskTimer(this.plugin, 100L, 100L);
    }

    @EventHandler
    public void onMobSpawn(CreatureSpawnEvent event) {
        if (!this.config.getBoolean("mob_ai.disable_ai_when_no_players_nearby.enabled")) {
            return;
        }
        LivingEntity mob = event.getEntity();
        boolean hasNearby = mob.getNearbyEntities((double)this.mobAiRadius, (double)this.mobAiRadius, (double)this.mobAiRadius).stream().anyMatch(e -> e instanceof Player);
        mob.setAI(hasNearby);
    }

    public void unregister() {
        CreatureSpawnEvent.getHandlerList().unregister((Listener)this);
    }
}

