/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.item;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.md_5.bungee.api.ChatColor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class ItemManagement
implements Listener {
    private final Plugin plugin;
    private BukkitTask autoClearTask;
    private FileConfiguration config;
    private BukkitTask stackTask;
    private boolean autoClearEnabled;
    private int autoClearInterval;
    private Set<Material> whitelist;
    private boolean stackingEnabled;
    private double stackRadius;
    private String hologramFormat;
    private String pickupBehavior;
    private final Map<UUID, Integer> stackedAmounts = new HashMap<UUID, Integer>();
    private final NamespacedKey STACK_KEY = new NamespacedKey("lesslag", "stack_id");
    private String itemName;

    public ItemManagement(Plugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        this.loadConfigValues();
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        this.startAutoClearTask();
        this.startStackingTask();
    }

    private void loadConfigValues() {
        this.autoClearEnabled = this.config.getBoolean("item_management.auto_clear_drops.enabled", true);
        this.autoClearInterval = this.config.getInt("item_management.auto_clear_drops.interval_seconds", 60);
        this.whitelist = this.config.getStringList("item_management.auto_clear_drops.whitelist").stream().map(name -> {
            try {
                return Material.valueOf((String)name.toUpperCase());
            }
            catch (IllegalArgumentException e) {
                this.plugin.getLogger().warning("Invalid whitelist item: " + name);
                return null;
            }
        }).filter(Objects::nonNull).collect(Collectors.toSet());
        this.stackingEnabled = this.config.getBoolean("item_management.item_stacking.enabled", true);
        this.stackRadius = this.config.getDouble("item_management.item_stacking.stack_radius", 3.0);
        this.hologramFormat = ChatColor.translateAlternateColorCodes((char)'&', (String)this.config.getString("item_management.item_stacking.hologram_format", "&e{item}&f x{amount}"));
        this.pickupBehavior = this.config.getString("item_management.item_stacking.pickup_behavior", "partial").toLowerCase();
    }

    public void reload() {
        this.config = this.plugin.getConfig();
        this.loadConfigValues();
        this.stopAutoClearTask();
        this.startAutoClearTask();
        this.stopStackingTask();
        this.stackedAmounts.clear();
    }

    private void startAutoClearTask() {
        if (!this.autoClearEnabled) {
            return;
        }
        long intervalTicks = (long)this.autoClearInterval * 20L;
        long warningTicks = intervalTicks - 200L;
        String prefix = this.plugin.getConfig().getString("settings.prefix");
        this.autoClearTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    Item item;
                    if (!(entity instanceof Item) || this.whitelist.contains((item = (Item)entity).getItemStack().getType())) continue;
                    item.remove();
                }
            }
            Bukkit.broadcastMessage((String)(prefix + String.valueOf(ChatColor.RED) + "All dropped items have been cleared!"));
        }, intervalTicks, intervalTicks);
        Bukkit.getScheduler().runTaskTimer(this.plugin, () -> Bukkit.broadcastMessage((String)(prefix + String.valueOf(ChatColor.YELLOW) + "All dropped items will be cleared in 10 seconds!")), warningTicks, intervalTicks);
    }

    private void startStackingTask() {
        if (!this.stackingEnabled) {
            return;
        }
        this.stackTask = Bukkit.getScheduler().runTaskTimer(this.plugin, () -> {
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntities()) {
                    Item item;
                    if (!(entity instanceof Item) || (item = (Item)entity).isDead()) continue;
                    if (!this.stackedAmounts.containsKey(item.getUniqueId())) {
                        int totalAmount = item.getItemStack().getAmount();
                        ItemStack newStack = item.getItemStack().clone();
                        newStack.setAmount(1);
                        newStack = this.tagStackedItem(newStack);
                        item.setItemStack(newStack);
                        this.stackedAmounts.put(item.getUniqueId(), totalAmount);
                        this.updateHologram(item);
                    }
                    this.stackNearbyItems(item);
                }
            }
        }, 0L, 10L);
    }

    private void stopStackingTask() {
        if (this.stackTask != null) {
            this.stackTask.cancel();
            this.stackTask = null;
        }
    }

    private void stopAutoClearTask() {
        if (this.autoClearTask != null) {
            this.autoClearTask.cancel();
            this.autoClearTask = null;
        }
    }

    public void disable() {
        this.stopAutoClearTask();
        this.stackedAmounts.clear();
    }

    private ItemStack tagStackedItem(ItemStack stack) {
        ItemStack tagged = stack.clone();
        ItemMeta meta = tagged.getItemMeta();
        meta.getPersistentDataContainer().set(this.STACK_KEY, PersistentDataType.STRING, (Object)"disable_stack");
        tagged.setItemMeta(meta);
        return tagged;
    }

    public void stackNearbyItems(Item baseItem) {
        if (!this.stackingEnabled || baseItem.isDead()) {
            return;
        }
        ItemStack baseStack = baseItem.getItemStack();
        int baseAmount = this.stackedAmounts.getOrDefault(baseItem.getUniqueId(), baseStack.getAmount());
        List toStack = baseItem.getNearbyEntities(this.stackRadius, this.stackRadius, this.stackRadius).stream().filter(e -> e instanceof Item).map(e -> (Item)e).filter(i -> !i.equals(baseItem)).filter(i -> this.canStack(baseStack, i.getItemStack())).collect(Collectors.toList());
        if (toStack.isEmpty()) {
            return;
        }
        for (Item other : toStack) {
            int otherAmount = this.stackedAmounts.getOrDefault(other.getUniqueId(), other.getItemStack().getAmount());
            baseAmount += otherAmount;
            other.remove();
            this.stackedAmounts.remove(other.getUniqueId());
        }
        ItemStack newStack = baseStack.clone();
        newStack.setAmount(1);
        newStack = this.tagStackedItem(newStack);
        baseItem.setItemStack(newStack);
        this.stackedAmounts.put(baseItem.getUniqueId(), baseAmount);
        this.updateHologram(baseItem);
    }

    private boolean canStack(ItemStack a, ItemStack b) {
        if (a.getType() != b.getType()) {
            return false;
        }
        ItemMeta metaA = a.getItemMeta();
        ItemMeta metaB = b.getItemMeta();
        if (metaA == null || metaB == null) {
            return false;
        }
        String tagA = (String)metaA.getPersistentDataContainer().get(this.STACK_KEY, PersistentDataType.STRING);
        String tagB = (String)metaB.getPersistentDataContainer().get(this.STACK_KEY, PersistentDataType.STRING);
        if (Objects.equals(tagA, "disable_stack") && Objects.equals(tagB, "disable_stack")) {
            ItemMeta cloneA = Bukkit.getItemFactory().getItemMeta(a.getType());
            ItemMeta cloneB = Bukkit.getItemFactory().getItemMeta(b.getType());
            if (cloneA != null) {
                cloneA = metaA.clone();
            }
            if (cloneB != null) {
                cloneB = metaB.clone();
            }
            if (cloneA != null) {
                cloneA.getPersistentDataContainer().remove(this.STACK_KEY);
            }
            if (cloneB != null) {
                cloneB.getPersistentDataContainer().remove(this.STACK_KEY);
            }
            return Objects.equals(cloneA, cloneB);
        }
        return Objects.equals(metaA, metaB);
    }

    private void updateHologram(Item item) {
        int amount = this.stackedAmounts.getOrDefault(item.getUniqueId(), item.getItemStack().getAmount());
        this.itemName = item.getItemStack().getItemMeta().hasDisplayName() ? item.getItemStack().getItemMeta().getDisplayName() : this.formatItemName(item.getItemStack().getType());
        String displayName = this.hologramFormat.replace("{item_type}", this.formatItemName(item.getItemStack().getType())).replace("{amount}", String.valueOf(amount)).replace("{item_name}", this.itemName);
        item.setCustomName(displayName);
        item.setCustomNameVisible(true);
    }

    private String formatItemName(Material material) {
        String name = material.name().toLowerCase().replace("_", " ");
        return Character.toUpperCase(name.charAt(0)) + name.substring(1);
    }

    private HashMap<Integer, ItemStack> simulateAddItem(Player player, ItemStack stack) {
        ItemStack[] contents = (ItemStack[])player.getInventory().getContents().clone();
        HashMap<Integer, ItemStack> leftovers = new HashMap<Integer, ItemStack>();
        ItemStack clone = stack.clone();
        int i = 0;
        while (i < contents.length && clone.getAmount() > 0) {
            int space;
            ItemStack current = contents[i];
            if (current == null || current.getType() == Material.AIR) {
                int max = clone.getMaxStackSize();
                if (clone.getAmount() <= max) {
                    clone.setAmount(0);
                } else {
                    clone.setAmount(clone.getAmount() - max);
                }
            } else if (current.isSimilar(clone) && (space = current.getMaxStackSize() - current.getAmount()) > 0) {
                if (clone.getAmount() <= space) {
                    clone.setAmount(0);
                } else {
                    clone.setAmount(clone.getAmount() - space);
                }
            }
            ++i;
        }
        if (clone.getAmount() > 0) {
            leftovers.put(0, clone);
        }
        return leftovers;
    }

    @EventHandler
    public void onItemPickup(EntityPickupItemEvent event) {
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        Item item = event.getItem();
        UUID id = item.getUniqueId();
        if (!this.stackedAmounts.containsKey(id)) {
            return;
        }
        int totalAmount = this.stackedAmounts.get(id);
        ItemStack cleanedItem = item.getItemStack().clone();
        ItemMeta meta = cleanedItem.getItemMeta();
        if (meta != null) {
            meta.getPersistentDataContainer().remove(this.STACK_KEY);
            cleanedItem.setItemMeta(meta);
        }
        if (this.pickupBehavior.equals("partial")) {
            HashMap leftovers = player.getInventory().addItem(new ItemStack[]{this.createItemWithAmount(cleanedItem, totalAmount)});
            int pickedUp = totalAmount - leftovers.values().stream().mapToInt(ItemStack::getAmount).sum();
            if (pickedUp >= totalAmount) {
                this.stackedAmounts.remove(id);
                item.remove();
            } else {
                this.stackedAmounts.put(id, totalAmount - pickedUp);
                this.updateHologram(item);
            }
        } else if (this.pickupBehavior.equals("full")) {
            ItemStack testStack = this.createItemWithAmount(cleanedItem, totalAmount);
            HashMap<Integer, ItemStack> simulatedLeftovers = this.simulateAddItem((Player)player, testStack);
            if (simulatedLeftovers.isEmpty()) {
                player.getInventory().addItem(new ItemStack[]{testStack});
                this.stackedAmounts.remove(id);
                item.remove();
            } else {
                event.setCancelled(true);
            }
        }
        event.setCancelled(true);
    }

    private ItemStack createItemWithAmount(ItemStack itemStack, int amount) {
        ItemStack stack = itemStack.clone();
        stack.setAmount(amount);
        return stack;
    }
}

