/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.entity;

import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitTask;

public class EntityManager {
    private final Plugin plugin;
    private BukkitTask chunkAndWorldCheckTask;
    private BukkitTask smartRemovalTask;
    private int maxEntitiesPerChunk;
    private int maxEntitiesPerWorld;
    private boolean disableNaturalSpawnOnLimit;
    private boolean killExcessEntities;
    private boolean smartRemovalEnabled;
    private List<String> smartRemovalWhitelist;

    public EntityManager(Plugin plugin) {
        this.plugin = plugin;
        this.loadConfigValues();
        this.startTasks();
    }

    public void loadConfigValues() {
        FileConfiguration config = this.plugin.getConfig();
        this.maxEntitiesPerChunk = config.getInt("entity_management.max_entities_per_chunk", 50);
        this.maxEntitiesPerWorld = config.getInt("entity_management.max_entities_per_world", 5000);
        this.disableNaturalSpawnOnLimit = config.getBoolean("entity_management.disable_natural_spawn_on_limit", true);
        this.killExcessEntities = config.getBoolean("entity_management.kill_excess_entities", true);
        this.smartRemovalEnabled = config.getBoolean("entity_management.smart_entity_removal.enabled", true);
        this.smartRemovalWhitelist = config.getStringList("entity_management.smart_entity_removal.whitelist").stream().map(String::toUpperCase).toList();
    }

    private void startTasks() {
        this.chunkAndWorldCheckTask = Bukkit.getScheduler().runTaskTimer(this.plugin, this::checkEntities, 0L, 200L);
        this.smartRemovalTask = Bukkit.getScheduler().runTaskTimer(this.plugin, this::smartEntityRemoval, 0L, 6000L);
    }

    public void stopTasks() {
        if (this.chunkAndWorldCheckTask != null) {
            this.chunkAndWorldCheckTask.cancel();
        }
        if (this.smartRemovalTask != null) {
            this.smartRemovalTask.cancel();
        }
    }

    public void reload() {
        this.loadConfigValues();
        this.stopTasks();
        this.startTasks();
    }

    private void checkEntities() {
        for (World world : Bukkit.getWorlds()) {
            int totalEntities = this.getNonPlayerEntities(world);
            if (totalEntities >= this.maxEntitiesPerWorld) {
                if (this.disableNaturalSpawnOnLimit) {
                    world.setSpawnFlags(false, false);
                }
                if (this.killExcessEntities) {
                    this.killExcessEntitiesInWorld(world, totalEntities - this.maxEntitiesPerWorld);
                }
            } else {
                world.setSpawnFlags(true, true);
            }
            Chunk[] chunkArray = world.getLoadedChunks();
            int n = chunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                Chunk chunk = chunkArray[n2];
                int entityCount = this.getNonPlayerEntities(chunk);
                if (entityCount >= this.maxEntitiesPerChunk && this.killExcessEntities) {
                    this.killExcessEntitiesInChunk(chunk, entityCount - this.maxEntitiesPerChunk);
                }
                ++n2;
            }
        }
    }

    private void smartEntityRemoval() {
        if (!this.smartRemovalEnabled) {
            return;
        }
        HashMap<String, AtomicInteger> entityCountMap = new HashMap<String, AtomicInteger>();
        String prefix = this.plugin.getConfig().getString("settings.prefix");
        for (World world : Bukkit.getWorlds()) {
            for (Entity entity : world.getEntities()) {
                String type;
                if (entity instanceof Player || this.smartRemovalWhitelist.contains(type = entity.getType().name())) continue;
                entityCountMap.computeIfAbsent(type, k -> new AtomicInteger()).incrementAndGet();
            }
        }
        String mostFrequent = entityCountMap.entrySet().stream().max(Comparator.comparingInt(e -> ((AtomicInteger)e.getValue()).get())).map(Map.Entry::getKey).orElse(null);
        if (mostFrequent != null) {
            int removed = 0;
            for (World world : Bukkit.getWorlds()) {
                for (Entity entity : world.getEntitiesByClass(Entity.class)) {
                    if (!entity.getType().name().equals(mostFrequent) || entity instanceof Player || this.smartRemovalWhitelist.contains(entity.getType().name().toUpperCase())) continue;
                    entity.remove();
                    ++removed;
                }
            }
            Bukkit.getLogger().info(prefix + "Smart entity removal executed: Removed all " + mostFrequent + " entities.");
            if (removed > 0) {
                this.notifyAdmins("\u00a7eSmart removal: \u00a7cRemoved \u00a7b" + removed + " \u00a7centities of type \u00a7b" + mostFrequent + " \u00a7cacross all worlds.");
            }
        }
    }

    private int getNonPlayerEntities(World world) {
        int count = 0;
        for (Entity entity : world.getEntities()) {
            if (entity instanceof Player) continue;
            ++count;
        }
        return count;
    }

    public Plugin getPlugin() {
        return this.plugin;
    }

    public boolean isOverEntityLimit(Chunk chunk, World world) {
        int chunkEntities = this.getNonPlayerEntities(chunk);
        int worldEntities = this.getNonPlayerEntities(world);
        return chunkEntities >= this.maxEntitiesPerChunk || worldEntities >= this.maxEntitiesPerWorld;
    }

    private int getNonPlayerEntities(Chunk chunk) {
        int count = 0;
        Entity[] entityArray = chunk.getEntities();
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (!(entity instanceof Player)) {
                ++count;
            }
            ++n2;
        }
        return count;
    }

    private void killExcessEntitiesInWorld(World world, int excess) {
        if (excess <= 0) {
            return;
        }
        int removed = 0;
        String lastType = "";
        for (Entity entity : world.getEntities()) {
            if (removed >= excess) break;
            if (entity instanceof Player) continue;
            lastType = entity.getType().name();
            entity.remove();
            ++removed;
        }
        if (removed > 0) {
            this.notifyAdmins("\u00a7eWorld cap removal: \u00a7cRemoved \u00a7b" + removed + " \u00a7centities of type \u00a7b" + lastType + " \u00a7cin world \u00a7b" + world.getName() + "\u00a7c.");
        }
    }

    private void killExcessEntitiesInChunk(Chunk chunk, int excess) {
        if (excess <= 0) {
            return;
        }
        int removed = 0;
        String lastType = "";
        Entity[] entityArray = chunk.getEntities();
        int n = entityArray.length;
        int n2 = 0;
        while (n2 < n) {
            Entity entity = entityArray[n2];
            if (removed >= excess) break;
            if (!(entity instanceof Player)) {
                lastType = entity.getType().name();
                entity.remove();
                ++removed;
            }
            ++n2;
        }
        if (removed > 0) {
            Location loc = chunk.getBlock(0, 0, 0).getLocation();
            this.notifyAdmins("\u00a7eChunk cap removal: \u00a7cRemoved \u00a7b" + removed + " \u00a7centities of type \u00a7b" + lastType + " \u00a7cin world \u00a7b" + loc.getWorld().getName() + " \u00a77(Chunk X:" + chunk.getX() + "\u00a77, Z:" + chunk.getZ() + "\u00a77).");
        }
    }

    private void notifyAdmins(String message) {
        String prefix = this.plugin.getConfig().getString("settings.prefix");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("lesslag.admin")) continue;
            player.sendMessage(prefix + message);
        }
    }
}

