/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag.chunk;

import java.util.HashSet;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class ChunkManager
implements Listener {
    private final Plugin plugin;
    private final FileConfiguration config;
    private boolean throttlingEnabled;
    private int maxChunksPerSecond;
    private int disableDurationSeconds;
    private boolean chunkLoadingDisabled = false;
    private int chunksLoadedThisSecond = 0;
    private final Set<Chunk> recentlyUnloadedChunks = new HashSet<Chunk>();

    public ChunkManager(Plugin plugin) {
        this.plugin = plugin;
        this.config = plugin.getConfig();
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        this.loadConfigValues();
        this.startChunkCounterResetTask();
    }

    private void loadConfigValues() {
        this.throttlingEnabled = this.config.getBoolean("chunk_loading.throttle_on_fast_player_movement.enabled", true);
        this.maxChunksPerSecond = this.config.getInt("chunk_loading.throttle_on_fast_player_movement.max_chunks_per_second", 30);
        this.disableDurationSeconds = this.config.getInt("chunk_loading.throttle_on_fast_player_movement.disable_duration_seconds", 5);
    }

    private void startChunkCounterResetTask() {
        new BukkitRunnable(){

            public void run() {
                ChunkManager.this.chunksLoadedThisSecond = 0;
            }
        }.runTaskTimer(this.plugin, 20L, 20L);
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        if (!this.throttlingEnabled) {
            return;
        }
        if (this.chunkLoadingDisabled) {
            Chunk chunk = event.getChunk();
            if (!this.recentlyUnloadedChunks.contains(chunk)) {
                this.recentlyUnloadedChunks.add(chunk);
                Bukkit.getScheduler().runTask(this.plugin, () -> {
                    boolean success;
                    if (chunk.isLoaded() && !(success = chunk.unload(true))) {
                        chunk.unload(false);
                    }
                });
                Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
                    boolean bl = this.recentlyUnloadedChunks.remove(chunk);
                }, 40L);
            }
            return;
        }
        ++this.chunksLoadedThisSecond;
        if (this.chunksLoadedThisSecond > this.maxChunksPerSecond) {
            this.triggerThrottle(event.getWorld(), event.isNewChunk());
        }
    }

    private void triggerThrottle(World world, boolean newChunk) {
        if (this.chunkLoadingDisabled) {
            return;
        }
        this.chunkLoadingDisabled = true;
        String info = "\u00a7cChunk loading temporarily disabled for \u00a7b" + this.disableDurationSeconds + "\u00a7cs in world: \u00a7b" + world.getName() + "\u00a7c | Reason: High chunk load rate (\u00a7b" + this.chunksLoadedThisSecond + "\u00a7c chunks/sec)";
        this.notifyAdmins(info);
        Bukkit.getScheduler().runTaskLater(this.plugin, () -> {
            this.chunkLoadingDisabled = false;
            this.notifyAdmins("\u00a7aChunk loading re-enabled in world: \u00a7b" + world.getName());
        }, (long)this.disableDurationSeconds * 20L);
    }

    private void notifyAdmins(String message) {
        String prefix = Bukkit.getPluginManager().getPlugin("LessLag").getConfig().getString("settings.prefix");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (!player.hasPermission("lesslag.admin")) continue;
            player.sendMessage(prefix + message);
        }
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        this.recentlyUnloadedChunks.remove(event.getChunk());
    }

    public void disable() {
        ChunkLoadEvent.getHandlerList().unregister((Listener)this);
        ChunkUnloadEvent.getHandlerList().unregister((Listener)this);
    }
}

