/*
 * Decompiled with CFR 0.152.
 */
package tk.bridgersilk.lesslag;

import com.comphenix.protocol.ProtocolLibrary;
import com.comphenix.protocol.ProtocolManager;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import tk.bridgersilk.lesslag.bstats.bukkit.Metrics;
import tk.bridgersilk.lesslag.chunk.ChunkManager;
import tk.bridgersilk.lesslag.entity.CommandControlListener;
import tk.bridgersilk.lesslag.entity.EntityManager;
import tk.bridgersilk.lesslag.entity.SpawnControlListener;
import tk.bridgersilk.lesslag.item.ItemManagement;
import tk.bridgersilk.lesslag.performance.PerformanceManager;
import tk.bridgersilk.lesslag.player.ChatListener;
import tk.bridgersilk.lesslag.player.PlayerJoinListener;
import tk.bridgersilk.lesslag.player.PlayerManager;
import tk.bridgersilk.lesslag.player.PlayerTeleportListener;
import tk.bridgersilk.lesslag.system.ConfigManager;
import tk.bridgersilk.lesslag.system.MainCommand;
import tk.bridgersilk.lesslag.system.Profiler;
import tk.bridgersilk.lesslag.world.WorldManager;

public class LessLag
extends JavaPlugin {
    private ConfigManager configManager;
    private Profiler profiler;
    private WorldManager worldManager;
    private ItemManagement itemManagement;
    private EntityManager entityManager;
    private PlayerManager playerManager;
    private PerformanceManager performanceManager;
    private ChunkManager chunkManager;
    private ProtocolManager protocolManager;

    public void onLoad() {
        this.protocolManager = ProtocolLibrary.getProtocolManager();
    }

    public void onEnable() {
        this.saveDefaultConfig();
        this.configManager = new ConfigManager(this);
        this.profiler = new Profiler(this);
        this.worldManager = new WorldManager(this);
        int pluginId = 27003;
        Metrics metrics = new Metrics(this, pluginId);
        new MainCommand(this);
        this.itemManagement = new ItemManagement((Plugin)this);
        this.entityManager = new EntityManager((Plugin)this);
        this.performanceManager = new PerformanceManager((Plugin)this);
        this.chunkManager = new ChunkManager((Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SpawnControlListener(this.entityManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CommandControlListener(this.entityManager), (Plugin)this);
        this.playerManager = new PlayerManager((Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this.playerManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerTeleportListener(this.playerManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ChatListener(this.playerManager), (Plugin)this);
        this.getLogger().info("LessLag enabled! Config loaded and Profiler initialized.");
    }

    public void onDisable() {
        this.getLogger().info("LessLag disabled!");
        if (this.worldManager != null) {
            this.worldManager.disable();
        }
        if (this.itemManagement != null) {
            this.itemManagement.disable();
        }
        if (this.entityManager != null) {
            this.entityManager.stopTasks();
        }
        if (this.performanceManager != null) {
            this.performanceManager.disable();
        }
        if (this.playerManager != null) {
            this.playerManager.disable();
        }
        if (this.chunkManager != null) {
            this.chunkManager.disable();
        }
    }

    public ConfigManager getConfigManager() {
        return this.configManager;
    }

    public Profiler getProfiler() {
        return this.profiler;
    }

    public void reloadPlugin() {
        this.reloadConfig();
        this.configManager.reloadConfig();
        if (this.profiler != null) {
            this.profiler.disable();
        }
        if (this.worldManager != null) {
            this.worldManager.disable();
        }
        if (this.itemManagement != null) {
            this.itemManagement.disable();
        }
        if (this.entityManager != null) {
            this.entityManager.stopTasks();
        }
        if (this.playerManager != null) {
            this.playerManager.disable();
        }
        if (this.chunkManager != null) {
            this.chunkManager.disable();
        }
        this.chunkManager = new ChunkManager((Plugin)this);
        if (this.performanceManager != null) {
            this.performanceManager.disable();
        }
        this.profiler = new Profiler(this);
        this.worldManager = new WorldManager(this);
        this.itemManagement = new ItemManagement((Plugin)this);
        this.entityManager = new EntityManager((Plugin)this);
        this.playerManager = new PlayerManager((Plugin)this);
        this.performanceManager = new PerformanceManager((Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerJoinListener(this.playerManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new PlayerTeleportListener(this.playerManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new ChatListener(this.playerManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new SpawnControlListener(this.entityManager), (Plugin)this);
        Bukkit.getPluginManager().registerEvents((Listener)new CommandControlListener(this.entityManager), (Plugin)this);
        this.getLogger().info("Plugin reloaded. Features updated with the latest config.");
    }
}

