/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.ingredient.BaseIngredient;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientGroup;
import dev.jsinco.brewery.api.ingredient.IngredientMeta;
import dev.jsinco.brewery.api.ingredient.IngredientWithMeta;
import java.lang.runtime.SwitchBootstraps;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class IngredientUtil {
    private IngredientUtil() {
        throw new UnsupportedOperationException("Utility class");
    }

    public static Map<BaseIngredient, Integer> sanitizeIngredients(Map<? extends Ingredient, Integer> ingredients) {
        HashMap<BaseIngredient, Integer> output = new HashMap<BaseIngredient, Integer>();
        for (Map.Entry<? extends Ingredient, Integer> entry : ingredients.entrySet()) {
            Ingredient ingredient = entry.getKey();
            if (ingredient instanceof IngredientGroup) {
                IngredientGroup ingredientGroup = (IngredientGroup)ingredient;
                ingredient = ingredientGroup.alternatives().stream().max(Comparator.comparing(groupIngredient -> IngredientUtil.score(groupIngredient).orElse(1.0))).orElse(null);
            }
            if (ingredient == null) continue;
            output.put(ingredient.toBaseIngredient(), entry.getValue());
        }
        return output;
    }

    public static List<BrewingStep> sanitizeSteps(List<BrewingStep> steps) {
        return steps.stream().map(IngredientUtil::sanitizeStep).toList();
    }

    public static BrewingStep sanitizeStep(BrewingStep step) {
        BrewingStep brewingStep = step;
        Objects.requireNonNull(brewingStep);
        BrewingStep brewingStep2 = brewingStep;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BrewingStep.Mix.class, BrewingStep.Cook.class}, (Object)brewingStep2, n)) {
            case 0 -> {
                BrewingStep.Mix mix = (BrewingStep.Mix)brewingStep2;
                yield mix.withIngredients(IngredientUtil.sanitizeIngredients(mix.ingredients()));
            }
            case 1 -> {
                BrewingStep.Cook cook = (BrewingStep.Cook)brewingStep2;
                yield cook.withIngredients(IngredientUtil.sanitizeIngredients(cook.ingredients()));
            }
            default -> step;
        };
    }

    public static Optional<Double> score(Ingredient ingredient) {
        if (ingredient instanceof IngredientWithMeta) {
            IngredientWithMeta ingredientWithMeta = (IngredientWithMeta)ingredient;
            return Optional.ofNullable(ingredientWithMeta.get(IngredientMeta.SCORE));
        }
        return Optional.empty();
    }
}

