/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.util;

import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.SequencedSet;

public class CollectionUtil {
    private CollectionUtil() {
    }

    @SafeVarargs
    public static <E> SequencedSet<E> sequencedSetOf(E ... elements) {
        return Collections.unmodifiableSequencedSet(new LinkedHashSet<E>(Arrays.asList(elements)));
    }

    public static <E> boolean isEqualWithOrdering(SequencedSet<E> set1, SequencedSet<E> set2) {
        if (set1.size() != set2.size()) {
            return false;
        }
        Iterator iter1 = set1.iterator();
        Iterator iter2 = set2.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            if (Objects.equals(iter1.next(), iter2.next())) continue;
            return false;
        }
        return true;
    }
}

