/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.recipes;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.recipe.RecipeCondition;
import dev.jsinco.brewery.api.recipe.ScoreCondition;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class RecipeConditions {
    @Nullable
    static BrewingStep sanitizeExpected(@Nullable List<BrewingStep> expected, int index) {
        if (expected == null) {
            return null;
        }
        return expected.size() > index ? expected.get(index) : null;
    }

    public record FirstStepImpl(BrewingStep.StepType stepType, List<ScoreCondition> conditions) implements RecipeCondition.FirstStep
    {
        @Override
        public boolean matches(@Nullable List<BrewingStep> expected, List<BrewingStep> actual) {
            if (actual.isEmpty()) {
                return false;
            }
            if (actual.getFirst().stepType() != this.stepType) {
                return false;
            }
            return this.conditions().stream().allMatch(scoreCondition -> scoreCondition.matches(RecipeConditions.sanitizeExpected(expected, 0), (BrewingStep)actual.getFirst()));
        }

        @Override
        public int complexity() {
            return 1 + this.conditions.size();
        }
    }

    public record AnyStepImpl(BrewingStep.StepType stepType, List<ScoreCondition> conditions) implements RecipeCondition.AnyStep
    {
        @Override
        public boolean matches(@Nullable List<BrewingStep> expected, List<BrewingStep> actual) {
            if (actual.isEmpty()) {
                return false;
            }
            for (int i = 0; i < actual.size(); ++i) {
                int index = i;
                if (actual.get(index).stepType() != this.stepType || !this.conditions.stream().allMatch(scoreCondition -> scoreCondition.matches(RecipeConditions.sanitizeExpected(expected, index), (BrewingStep)actual.get(index)))) continue;
                return true;
            }
            return false;
        }

        @Override
        public int complexity() {
            return 1 + this.conditions.size();
        }
    }

    public record ExactStepImpl(BrewingStep.StepType stepType, List<ScoreCondition> conditions, int index) implements RecipeCondition.ExactStep
    {
        @Override
        public boolean matches(@Nullable List<BrewingStep> expected, List<BrewingStep> actual) {
            if (actual.isEmpty()) {
                return false;
            }
            if (actual.size() <= this.index) {
                return false;
            }
            if (actual.get(this.index).stepType() != this.stepType) {
                return false;
            }
            return this.conditions().stream().allMatch(scoreCondition -> scoreCondition.matches(RecipeConditions.sanitizeExpected(expected, this.index), (BrewingStep)actual.get(this.index)));
        }

        @Override
        public int complexity() {
            return 1 + this.conditions.size();
        }
    }

    public record LastStepImpl(BrewingStep.StepType stepType, List<ScoreCondition> conditions) implements RecipeCondition.LastStep
    {
        @Override
        public boolean matches(@Nullable List<BrewingStep> expected, List<BrewingStep> actual) {
            if (actual.isEmpty()) {
                return false;
            }
            if (actual.getLast().stepType() != this.stepType) {
                return false;
            }
            return this.conditions().stream().allMatch(scoreCondition -> scoreCondition.matches(RecipeConditions.sanitizeExpected(expected, actual.size() - 1), (BrewingStep)actual.getLast()));
        }

        @Override
        public int complexity() {
            return 1 + this.conditions.size();
        }
    }
}

