/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.format;

import dev.jsinco.brewery.format.TimeFormat;
import dev.jsinco.brewery.format.TimeModifier;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TimeFormatter {
    public static String format(long timeTicks, TimeFormat format) {
        return TimeFormatter.format(timeTicks, format, TimeModifier.NORMAL);
    }

    public static String format(long timeTicks, TimeFormat format, TimeModifier modifier) {
        Pattern[] blockPatterns;
        LinkedHashMap<String, Long> placeholders = new LinkedHashMap<String, Long>();
        double tpm = modifier.getTicksPerMinute();
        long totalMinutes = (long)Math.floor((double)timeTicks / tpm);
        placeholders.put("minutes-total", totalMinutes);
        long totalSeconds = (long)Math.floor((double)timeTicks * 60.0 / tpm);
        placeholders.put("seconds-total", totalSeconds);
        long totalHours = totalMinutes / 60L;
        placeholders.put("hours-total", totalHours);
        long totalDays = totalHours / 24L;
        placeholders.put("days-total", totalDays);
        long totalYears = totalDays / 365L;
        placeholders.put("years-total", totalYears);
        long totalDecades = totalYears / 10L;
        placeholders.put("decades-total", totalDecades);
        long minutes = totalMinutes % 60L;
        placeholders.put("minutes", minutes);
        long hours = totalHours % 24L;
        placeholders.put("hours", hours);
        long days = totalDays % 365L;
        placeholders.put("days", days);
        long years = totalYears % 10L;
        placeholders.put("years", years);
        long ticks = (long)((double)timeTicks - Math.floor((double)totalMinutes * tpm));
        placeholders.put("ticks", ticks);
        long seconds = (long)Math.floor(((double)timeTicks - Math.floor((double)totalMinutes * tpm)) * 60.0 / tpm);
        placeholders.put("seconds", seconds);
        placeholders.put("ticks-total", timeTicks);
        placeholders.put("decades", totalDecades);
        String result = format.get();
        for (Map.Entry entry : placeholders.entrySet()) {
            result = result.replace("<" + (String)entry.getKey() + ">", String.valueOf(entry.getValue()));
        }
        for (Map.Entry entry : placeholders.entrySet()) {
            boolean condition = (Long)entry.getValue() > 0L;
            String name = (String)entry.getKey();
            result = result.replaceAll("(?s)<if-" + Pattern.quote(name) + ">(.*?)</if-" + Pattern.quote(name) + ">", condition ? "$1" : "");
            result = result.replaceAll("(?s)<if-!" + Pattern.quote(name) + ">(.*?)</if-!" + Pattern.quote(name) + ">", condition ? "" : "$1");
        }
        for (Pattern blockPattern : blockPatterns = new Pattern[]{Pattern.compile("\\[\\[\\[(.*?)\\]\\]\\](?:<<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>>|<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>|<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>)?|\\{\\{\\{(.*?)\\}\\}\\}(?:<<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>>|<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>|<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>)?", 32), Pattern.compile("\\[\\[(.*?)\\]\\](?:<<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>>|<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>|<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>)?|\\{\\{(.*?)\\}\\}(?:<<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>>|<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>|<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>)?", 32), Pattern.compile("\\[(.*?)](?:<<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>>|<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>|<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>)?|\\{(.*?)}(?:<<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>>|<<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>>|<\\s*(\\d+(?:\\s*-\\s*\\d+)?)\\s*>)?", 32)}) {
            Matcher matcher = blockPattern.matcher(result);
            StringBuilder sb = new StringBuilder();
            while (matcher.find()) {
                boolean matches;
                String content;
                int blockStart = matcher.start();
                String prefix = result.substring(0, blockStart);
                StringBuilder outside = new StringBuilder(prefix.length());
                boolean inSquare = false;
                boolean inCurly = false;
                boolean inAngle = false;
                for (int i = 0; i < prefix.length(); ++i) {
                    char c = prefix.charAt(i);
                    if (!inCurly && !inAngle && c == '[') {
                        inSquare = true;
                        outside.append(' ');
                        continue;
                    }
                    if (inSquare && c == ']') {
                        inSquare = false;
                        outside.append(' ');
                        continue;
                    }
                    if (!inSquare && !inAngle && c == '{') {
                        inCurly = true;
                        outside.append(' ');
                        continue;
                    }
                    if (inCurly && c == '}') {
                        inCurly = false;
                        outside.append(' ');
                        continue;
                    }
                    if (!inSquare && !inCurly && c == '<') {
                        inAngle = true;
                        outside.append(' ');
                        continue;
                    }
                    if (inAngle && c == '>') {
                        inAngle = false;
                        outside.append(' ');
                        continue;
                    }
                    if (inSquare || inCurly || inAngle) {
                        outside.append(' ');
                        continue;
                    }
                    outside.append(c);
                }
                Matcher num = Pattern.compile("(\\d+)").matcher(outside);
                long value = 0L;
                while (num.find()) {
                    value = Long.parseLong(num.group(1));
                }
                boolean isCurly = matcher.group(5) != null;
                String spec = null;
                int mode = 0;
                if (isCurly) {
                    content = matcher.group(5);
                    if (matcher.group(6) != null) {
                        spec = matcher.group(6);
                        mode = 2;
                    } else if (matcher.group(7) != null) {
                        spec = matcher.group(7);
                        mode = 1;
                    } else if (matcher.group(8) != null) {
                        spec = matcher.group(8);
                        mode = 0;
                    }
                } else {
                    content = matcher.group(1);
                    if (matcher.group(2) != null) {
                        spec = matcher.group(2);
                        mode = 2;
                    } else if (matcher.group(3) != null) {
                        spec = matcher.group(3);
                        mode = 1;
                    } else if (matcher.group(4) != null) {
                        spec = matcher.group(4);
                        mode = 0;
                    }
                }
                long compareValue = value;
                if (mode == 1) {
                    compareValue = value % 10L;
                } else if (mode == 2) {
                    compareValue = value % 100L;
                }
                if (spec == null) {
                    matches = compareValue == 1L;
                } else {
                    String str = spec.replaceAll("\\s+", "");
                    int dash = str.indexOf(45);
                    if (dash >= 0) {
                        long b;
                        long a = Long.parseLong(str.substring(0, dash));
                        if (a > (b = Long.parseLong(str.substring(dash + 1)))) {
                            long temp = a;
                            a = b;
                            b = temp;
                        }
                        matches = compareValue >= a && compareValue <= b;
                    } else {
                        long n = Long.parseLong(str);
                        matches = compareValue == n;
                    }
                }
                String replacement = isCurly == matches ? content : "";
                matcher.appendReplacement(sb, Matcher.quoteReplacement(replacement));
            }
            matcher.appendTail(sb);
            result = sb.toString();
        }
        return result;
    }
}

