/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import dev.jsinco.brewery.time.Duration;
import dev.jsinco.brewery.time.TimeUtil;
import java.util.Set;
import lombok.NonNull;

public class TicksDurationSerializer
implements ObjectSerializer<Duration.Ticks> {
    @Override
    public boolean supports(@NonNull Class<? super Duration.Ticks> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Duration.Ticks.class == type;
    }

    @Override
    public void serialize(@NonNull Duration.Ticks object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.setValue(TimeUtil.minimalString(object.durationTicks(), TimeUtil.TimeUnit.SECONDS, Set.of(TimeUtil.TimeUnit.AGING_YEARS, TimeUtil.TimeUnit.COOKING_MINUTES)));
    }

    @Override
    public Duration.Ticks deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String durationString = data.getValue(String.class);
        if (durationString == null) {
            return new Duration.Ticks(0L);
        }
        return new Duration.Ticks(TimeUtil.parse(durationString, TimeUtil.TimeUnit.MINUTES));
    }
}

