/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.serializers;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.effect.modifier.ModifierExpression;
import dev.jsinco.brewery.api.effect.modifier.ModifierTooltip;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import lombok.NonNull;

public class ModifierTooltipSerializer
implements ObjectSerializer<ModifierTooltip> {
    @Override
    public boolean supports(@NonNull Class<? super ModifierTooltip> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return type == ModifierTooltip.class;
    }

    @Override
    public void serialize(@NonNull ModifierTooltip object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        data.add("filter", object.filter());
        data.add("brewing-tooltip", object.brewingTooltip());
        data.add("default-tooltip", object.defaultTooltip());
        data.add("sealed-tooltip", object.sealedTooltip());
    }

    @Override
    public ModifierTooltip deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        ModifierExpression modifierExpression = data.get("filter", ModifierExpression.class);
        String brewingTooltip = data.get("brewing-tooltip", String.class);
        String defaultTooltip = data.get("default-tooltip", String.class);
        String sealedTooltip = data.get("sealed-tooltip", String.class);
        Preconditions.checkArgument((modifierExpression != null ? 1 : 0) != 0, (Object)"Tooltip display requires an filter and a tooltip message");
        return new ModifierTooltip(modifierExpression, brewingTooltip, defaultTooltip, sealedTooltip);
    }
}

