/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.configuration.locale;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import dev.jsinco.brewery.configuration.Config;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.kyori.adventure.key.Key;
import net.kyori.adventure.text.minimessage.translation.MiniMessageTranslator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BreweryTranslator
extends MiniMessageTranslator {
    private Map<Locale, Properties> translations;
    private final File localeDirectory;

    public BreweryTranslator(File localeDirectory) {
        this.localeDirectory = localeDirectory;
    }

    public void reload() {
        this.syncLangFiles();
        this.loadLangFiles();
    }

    private void syncLangFiles() {
        if (!this.localeDirectory.exists() && !this.localeDirectory.mkdirs()) {
            throw new IllegalStateException("Failed to create locale directory at " + this.localeDirectory.getAbsolutePath());
        }
        try {
            Enumeration<URL> resources = ((Object)((Object)this)).getClass().getClassLoader().getResources("locale");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                FileSystem fs = "jar".equals(url.getProtocol()) ? FileSystems.newFileSystem(url.toURI(), Collections.emptyMap()) : null;
                try {
                    Path internalLocaleDir = fs == null ? Paths.get(url.toURI()) : fs.getPath("locale", new String[0]);
                    DirectoryStream<Path> stream = Files.newDirectoryStream(internalLocaleDir, "*.lang.properties");
                    try {
                        for (Path path : stream) {
                            this.mergeAndStoreProperties(path);
                        }
                    }
                    finally {
                        if (stream == null) continue;
                        stream.close();
                    }
                }
                finally {
                    if (fs == null) continue;
                    fs.close();
                }
            }
        }
        catch (IOException | URISyntaxException e) {
            throw new RuntimeException("Failed to sync language files", e);
        }
    }

    private void mergeAndStoreProperties(Path internalFile) throws IOException {
        String fileName = internalFile.getFileName().toString();
        File externalFile = new File(this.localeDirectory, fileName);
        Properties internalProps = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(internalFile, StandardCharsets.UTF_8);){
            internalProps.load(reader);
        }
        Properties merged = new Properties();
        if (externalFile.exists()) {
            Properties externalProps = new Properties();
            try (InputStreamReader reader = new InputStreamReader((InputStream)new FileInputStream(externalFile), StandardCharsets.UTF_8);){
                externalProps.load(reader);
            }
            merged.putAll((Map<?, ?>)externalProps);
            for (String key : internalProps.stringPropertyNames()) {
                merged.putIfAbsent(key, internalProps.getProperty(key));
            }
        } else {
            merged.putAll((Map<?, ?>)internalProps);
            if (!externalFile.createNewFile()) {
                throw new IOException("Could not create file: " + String.valueOf(externalFile));
            }
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(externalFile), StandardCharsets.UTF_8);){
            this.storeWithoutComments(merged, writer);
        }
    }

    private void storeWithoutComments(Properties props, Writer writer) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(props.stringPropertyNames());
        Collections.sort(keys);
        for (String key : keys) {
            writer.write(key + "=" + props.getProperty(key) + "\n");
        }
    }

    private void loadLangFiles() {
        if (!this.localeDirectory.isDirectory()) {
            throw new IllegalArgumentException("Locale directory is not a directory!");
        }
        ImmutableMap.Builder translationsBuilder = new ImmutableMap.Builder();
        for (File translationFile : this.localeDirectory.listFiles(file -> file.getName().endsWith(".lang.properties"))) {
            try (FileInputStream inputStream = new FileInputStream(translationFile);){
                Properties translation = new Properties();
                translation.load(new InputStreamReader((InputStream)inputStream, StandardCharsets.UTF_8));
                Locale locale = Locale.forLanguageTag(translationFile.getName().replaceAll(".lang.properties$", ""));
                if (locale == null) continue;
                translationsBuilder.put((Object)locale, (Object)translation);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.translations = translationsBuilder.build();
        Preconditions.checkArgument((boolean)this.translations.containsKey(Config.config().language()), (Object)("Unknown translation: " + String.valueOf(Config.config().language())));
    }

    @NotNull
    public Key name() {
        return Key.key((String)"brewery:global_translator");
    }

    @Nullable
    public String getMiniMessageString(@NotNull String key, @NotNull Locale locale) {
        Properties translations = null;
        if (Config.config().clientSideTranslations()) {
            translations = this.translations.get(locale);
        }
        if (translations == null) {
            translations = this.translations.get(Config.config().language());
        }
        Preconditions.checkState((translations != null ? 1 : 0) != 0, (Object)"Should have found a translation!");
        return translations.getProperty(key);
    }
}

