/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.structure.serializer;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.structure.MaterialTag;
import dev.jsinco.brewery.api.structure.StructureMeta;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.Materials;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;

public class StructureMetaSerializer
implements ObjectSerializer<BreweryStructure.Meta> {
    @Override
    public boolean supports(@NonNull Class<? super BreweryStructure.Meta> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return BreweryStructure.Meta.class == type;
    }

    @Override
    public void serialize( @NonNull BreweryStructure.Meta object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        for (Map.Entry<StructureMeta<?>, Object> entry : object.data().entrySet()) {
            data.add(entry.getKey().key().minimalized(), entry.getValue());
        }
    }

    @Override
    public BreweryStructure.Meta deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        Set<String> keys = data.asMap().keySet();
        HashMap meta = new HashMap();
        for (String key : keys) {
            BreweryKey breweryKey = BreweryKey.parse(key);
            if (breweryKey.equals(BreweryKey.parse("tagged_material"))) {
                Materials materials = data.get(key, Materials.class);
                meta.put(StructureMeta.DISTILLATE_MATERIAL_TAG, new MaterialTag(materials.values(), 1, 1, 1));
                meta.put(StructureMeta.MIXTURE_MATERIAL_TAG, new MaterialTag(materials.values(), 1, 2, 1));
                continue;
            }
            StructureMeta<?> metaItem = BreweryRegistry.STRUCTURE_META.get(breweryKey);
            Preconditions.checkArgument((metaItem != null ? 1 : 0) != 0, (Object)("Unknown meta: " + key));
            meta.put(metaItem, data.get(key, metaItem.vClass()));
        }
        Preconditions.checkArgument((boolean)meta.containsKey(StructureMeta.TYPE), (Object)"Expected structure type to be present");
        StructureType type = (StructureType)meta.get(StructureMeta.TYPE);
        type.getMissingMandatory(meta.keySet()).forEach(structureMeta -> meta.put((StructureMeta<?>)structureMeta, structureMeta.defaultValue()));
        if (type == StructureType.DISTILLERY) {
            Preconditions.checkArgument((meta.containsKey(StructureMeta.MIXTURE_MATERIAL_TAG) || meta.containsKey(StructureMeta.MIXTURE_ACCESS_POINTS) ? 1 : 0) != 0, (Object)"Missing meta 'mixture_material_tag' or 'mixture_access_points'!");
            Preconditions.checkArgument((meta.containsKey(StructureMeta.DISTILLATE_MATERIAL_TAG) || meta.containsKey(StructureMeta.DISTILLATE_ACCESS_POINTS) ? 1 : 0) != 0, (Object)"Missing meta 'distillate_material_tag' or 'distillate_access_points'");
        }
        return new BreweryStructure.Meta(meta);
    }
}

