/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.recipe;

import dev.jsinco.brewery.api.recipe.DefaultRecipe;
import dev.jsinco.brewery.api.recipe.RecipeCondition;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffectsImpl;
import dev.jsinco.brewery.bukkit.util.ColorUtil;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.ConfigurationSection;
import dev.jsinco.brewery.lib.org.simpleyaml.configuration.file.YamlFile;
import dev.jsinco.brewery.recipes.RecipeConditionsReader;
import java.io.File;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.bukkit.inventory.ItemStack;

public class DefaultRecipeReader {
    public static Map<String, CompletableFuture<DefaultRecipe<ItemStack>>> readDefaultRecipes(File folder) {
        Path mainDir = folder.toPath();
        YamlFile recipesFile = new YamlFile(mainDir.resolve("incomplete-recipes.yml").toFile());
        try {
            recipesFile.createOrLoadWithComments();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        ConfigurationSection recipesSection = recipesFile.getConfigurationSection("incomplete-recipes");
        if (recipesSection == null) {
            return Map.of();
        }
        HashMap<String, CompletableFuture<DefaultRecipe<ItemStack>>> recipes = new HashMap<String, CompletableFuture<DefaultRecipe<ItemStack>>>();
        for (String recipeName : recipesSection.getKeys(false)) {
            try {
                BukkitRecipeResult bukkitRecipeResult = DefaultRecipeReader.getDefaultRecipe(recipesSection.getConfigurationSection(recipeName));
                CompletableFuture<List<Object>> recipeConditionsFuture = !recipesSection.isConfigurationSection(recipeName + ".condition") ? CompletableFuture.completedFuture(List.of()) : RecipeConditionsReader.fromConfigSection(recipesSection.getConfigurationSection(recipeName + ".condition"), BukkitIngredientManager.INSTANCE);
                recipes.put(recipeName, (CompletableFuture<DefaultRecipe<ItemStack>>)recipeConditionsFuture.thenApplyAsync(recipeConditions -> new DefaultRecipe<ItemStack>(bukkitRecipeResult, (List<RecipeCondition>)recipeConditions, recipesSection.getBoolean(recipeName + ".condition.for-ruined-brews", true))));
            }
            catch (Throwable e) {
                Logger.logErr("Could not read default recipe: " + recipeName);
                Logger.logErr(e);
            }
        }
        return recipes;
    }

    public static BukkitRecipeResult getDefaultRecipe(ConfigurationSection defaultRecipe) {
        return new BukkitRecipeResult.Builder().name(defaultRecipe.getString("name", "Cauldron Brew")).lore(defaultRecipe.getStringList("lore")).color(ColorUtil.parseColorString(defaultRecipe.getString("color", "BLUE"))).customModelData(defaultRecipe.getInt("custom-model-data", -1)).glint(defaultRecipe.getBoolean("glint", false)).recipeEffects(RecipeEffectsImpl.GENERIC).appendBrewInfoLore(false).build();
    }
}

