/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.recipe;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewScore;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.integration.Integration;
import dev.jsinco.brewery.api.recipe.RecipeEffects;
import dev.jsinco.brewery.api.recipe.RecipeResult;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.api.integration.IntegrationTypes;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.recipe.RecipeEffectsImpl;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.configuration.BrewTooltipType;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.configuration.DrunkenModifierSection;
import dev.jsinco.brewery.effect.DrunkStateImpl;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.datacomponent.DataComponentBuilder;
import io.papermc.paper.datacomponent.DataComponentTypes;
import io.papermc.paper.datacomponent.item.CustomModelData;
import io.papermc.paper.datacomponent.item.ItemEnchantments;
import io.papermc.paper.datacomponent.item.ItemLore;
import io.papermc.paper.datacomponent.item.PotionContents;
import java.lang.runtime.SwitchBootstraps;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.stream.Stream;
import lombok.Generated;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.minimessage.translation.Argument;
import net.kyori.adventure.translation.GlobalTranslator;
import org.bukkit.Color;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.ItemType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitRecipeResult
implements RecipeResult<ItemStack> {
    @NotNull
    public static final RecipeResult<ItemStack> GENERIC = new Builder().lore(List.of()).name("Generic").recipeEffects(RecipeEffectsImpl.GENERIC).build();
    private final boolean glint;
    private final int customModelData;
    @Nullable
    private final NamespacedKey itemModel;
    @Nullable
    private final BreweryKey customId;
    private final String name;
    private final List<String> lore;
    private final RecipeEffectsImpl recipeEffects;
    private final Color color;
    private final boolean appendBrewInfoLore;

    private BukkitRecipeResult(boolean glint, int customModelData, @Nullable NamespacedKey itemModel, RecipeEffectsImpl recipeEffects, String name, List<String> lore, Color color, boolean appendBrewInfoLore, @Nullable BreweryKey customId) {
        this.glint = glint;
        this.customModelData = customModelData;
        this.itemModel = itemModel;
        this.recipeEffects = recipeEffects;
        this.name = name;
        this.lore = lore;
        this.color = color;
        this.appendBrewInfoLore = appendBrewInfoLore;
        this.customId = customId;
    }

    @Override
    public ItemStack newBrewItem(@NotNull BrewScore score, @NotNull Brew brew, @NotNull Brew.State state) {
        ItemStack itemStack = this.newLorelessItem();
        this.applyLore(itemStack, score, brew, state);
        return itemStack;
    }

    @Override
    public ItemStack newLorelessItem() {
        ItemStack itemStack;
        if (this.customId != null) {
            itemStack = this.createCustomItem();
            if (itemStack != null) {
                this.applyData(itemStack);
                return itemStack;
            }
            Logger.logErr("Invalid item id '" + String.valueOf(this.customId) + "' for recipe: " + this.name);
        }
        itemStack = new ItemStack(Material.POTION);
        this.applyData(itemStack);
        return itemStack;
    }

    @Override
    public RecipeEffects effects() {
        return this.recipeEffects;
    }

    @Override
    public Component displayName() {
        return MiniMessage.miniMessage().deserialize((Object)this.name);
    }

    @Nullable
    private ItemStack createCustomItem() {
        if (this.customId.namespace().equals("minecraft")) {
            ItemType itemType = (ItemType)Registry.ITEM.get(BukkitAdapter.toNamespacedKey(this.customId));
            if (itemType == null || itemType == ItemType.AIR) {
                return null;
            }
            return itemType.createItemStack();
        }
        return TheBrewingProject.getInstance().getIntegrationManager().getIntegrationRegistry().getIntegrations(IntegrationTypes.ITEM).stream().filter(Integration::isEnabled).filter(integration -> this.customId.namespace().equals(integration.getId())).findAny().orElseThrow(() -> new IllegalStateException("Namespace should be within the supported items plugins")).createItem(this.customId.key()).orElse(null);
    }

    private void applyData(ItemStack itemStack) {
        BrewAdapter.hideTooltips(itemStack);
        itemStack.setData(DataComponentTypes.CUSTOM_NAME, (Object)MessageUtil.miniMessage(this.name, new TagResolver[0]).decoration(TextDecoration.ITALIC, false).colorIfAbsent((TextColor)NamedTextColor.WHITE));
        if (this.glint) {
            itemStack.setData(DataComponentTypes.ENCHANTMENTS, (DataComponentBuilder)ItemEnchantments.itemEnchantments().add(Enchantment.MENDING, 1));
        }
        if (this.customModelData > 0) {
            itemStack.setData(DataComponentTypes.CUSTOM_MODEL_DATA, (Object)((CustomModelData)CustomModelData.customModelData().addFloat((float)this.customModelData).build()));
        }
        if (this.itemModel != null) {
            itemStack.setData(DataComponentTypes.ITEM_MODEL, (Object)this.itemModel);
        }
        this.recipeEffects.applyTo(itemStack);
        itemStack.setData(DataComponentTypes.POTION_CONTENTS, (DataComponentBuilder)PotionContents.potionContents().customColor(this.color));
    }

    /*
     * Loose catch block
     */
    private void applyLore(ItemStack itemStack, BrewScore score, Brew brew, Brew.State state) {
        Stream.Builder<Component> fullLoreBuilder;
        block23: {
            fullLoreBuilder = Stream.builder();
            TagResolver resolver = this.getResolver(score);
            block22: for (BrewTooltipType tooltipType : Config.config().brewTooltipOrder()) {
                if (!this.appendBrewInfoLore && BrewTooltipType.RECIPE_LORE != tooltipType) continue;
                block2 : switch (tooltipType) {
                    case RECIPE_LORE: {
                        this.lore.stream().map(line -> MessageUtil.miniMessage(line, MessageUtil.getScoreTagResolver(score))).forEach(fullLoreBuilder);
                        break;
                    }
                    case SCORE: {
                        String string;
                        Object object;
                        Brew.State state2;
                        Objects.requireNonNull(state);
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Brew.State.Brewing.class, Brew.State.Other.class, Brew.State.Seal.class}, (Object)state2, n)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                object = (Brew.State.Brewing)state2;
                                fullLoreBuilder.add((Component)Component.translatable((String)"tbp.brew.tooltip.quality-brewing", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)resolver)}));
                                break block2;
                            }
                            case 1: {
                                Brew.State.Other other = (Brew.State.Other)state2;
                                fullLoreBuilder.add((Component)Component.translatable((String)"tbp.brew.tooltip.quality", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)resolver)}));
                                break block2;
                            }
                            case 2: 
                        }
                        Brew.State.Seal seal = (Brew.State.Seal)state2;
                        String ignored = string = seal.message();
                        fullLoreBuilder.add((Component)Component.translatable((String)"tbp.brew.tooltip.quality-sealed", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)resolver)}));
                        break;
                    }
                    case MODIFIER: {
                        this.applyDrunkenTooltips(state, fullLoreBuilder, resolver);
                        break;
                    }
                    case SEALED_TEXT: {
                        if (!(state instanceof Brew.State.Seal)) continue block22;
                        Brew.State state2 = (Brew.State.Seal)state;
                        Object object = ((Brew.State.Seal)state2).message();
                        Object message = object;
                        if (message == null) continue block22;
                        fullLoreBuilder.add((Component)Component.translatable((String)"tbp.brew.tooltip.volume", (ComponentLike[])new ComponentLike[]{Argument.tagResolver((TagResolver)TagResolver.resolver((TagResolver[])new TagResolver[]{resolver, Placeholder.parsed((String)"volume", (String)message)}))}));
                        break;
                    }
                    case BREWERS: {
                        this.applyBrewersTooltip(brew, fullLoreBuilder);
                        break;
                    }
                    case STEPS: {
                        Brew.State state2;
                        Objects.requireNonNull(state);
                        int n = 0;
                        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Brew.State.Brewing.class, Brew.State.Other.class, Brew.State.Seal.class}, (Object)state2, n)) {
                            default: {
                                throw new MatchException(null, null);
                            }
                            case 0: {
                                Brew.State.Brewing ignored = (Brew.State.Brewing)state2;
                                MessageUtil.compileBrewInfo(brew, score, false).forEach(fullLoreBuilder::add);
                                break block2;
                            }
                            case 1: {
                                Brew.State.Other ignored = (Brew.State.Other)state2;
                                this.addLastStepLore(brew, fullLoreBuilder, score, state);
                                break block2;
                            }
                            case 2: 
                        }
                        Brew.State.Seal ignored = (Brew.State.Seal)state2;
                        this.addLastStepLore(brew, fullLoreBuilder, score, state);
                        break;
                    }
                    case EMPTY_LINE: {
                        fullLoreBuilder.add((Component)Component.empty());
                    }
                }
            }
            break block23;
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
        }
        itemStack.setData(DataComponentTypes.LORE, (Object)ItemLore.lore(fullLoreBuilder.build().map(component -> component.decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE)).map(component -> component.colorIfAbsent((TextColor)NamedTextColor.GRAY)).map(component -> GlobalTranslator.render((Component)component, (Locale)Config.config().language())).toList()));
    }

    private void applyBrewersTooltip(Brew brew, Stream.Builder<Component> streamBuilder) {
        SequencedCollection<Object> brewers;
        switch (Config.config().brewersDisplay()) {
            default: {
                throw new MatchException(null, null);
            }
            case NONE: {
                SequencedCollection<Object> sequencedCollection = List.of();
                break;
            }
            case FIRST_STEP: {
                SequencedCollection<Object> sequencedCollection = brew.getCompletedSteps().stream().findFirst().map(BrewingStep::brewers).orElseGet(LinkedHashSet::new);
                break;
            }
            case LEAD_BREWER: {
                SequencedCollection<Object> sequencedCollection = brew.leadBrewer().stream().toList();
                break;
            }
            case LAST_STEP: {
                SequencedCollection<Object> sequencedCollection = brew.lastCompletedStep().brewers();
                break;
            }
            case ALL: {
                SequencedCollection<Object> sequencedCollection = brewers = brew.getBrewers();
            }
        }
        if (!brewers.isEmpty()) {
            streamBuilder.add(MessageUtil.translated("tbp.brew.tooltip.brewer", new TagResolver[]{Placeholder.component((String)"brewers", (ComponentLike)((ComponentLike)brewers.stream().map(BukkitMessageUtil::uuidToPlayerName).collect(Component.toComponent())))}));
        }
    }

    private void addLastStepLore(Brew brew, Stream.Builder<Component> streamBuilder, BrewScore score, Brew.State state) {
        int lastIndex = brew.getCompletedSteps().size() - 1;
        BrewingStep lastCompleted = brew.lastCompletedStep();
        streamBuilder.add(lastCompleted.infoDisplay(state, MessageUtil.getBrewStepTagResolver(lastCompleted, score.getPartialScores(lastIndex), score.brewDifficulty())));
    }

    private void applyDrunkenTooltips(Brew.State state, Stream.Builder<Component> streamBuilder, TagResolver resolver) {
        DrunkenModifierSection.modifiers().drunkenTooltips().stream().filter(modifierTooltip -> modifierTooltip.filter().evaluate(DrunkStateImpl.compileVariables(this.recipeEffects.getModifiers(), null, 0.0)) > 0.0).map(modifierTooltip -> modifierTooltip.getTooltip(state)).filter(Objects::nonNull).map(miniMessage -> MessageUtil.miniMessage(miniMessage, resolver)).forEach(streamBuilder::add);
    }

    @NotNull
    private TagResolver getResolver(BrewScore score) {
        TagResolver.Builder output = TagResolver.builder();
        output.resolvers(new TagResolver[]{MessageUtil.numberedModifierTagResolver(this.recipeEffects.getModifiers(), null), MessageUtil.getScoreTagResolver(score)});
        return output.build();
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public List<String> getLore() {
        return this.lore;
    }

    @Generated
    public RecipeEffectsImpl getRecipeEffects() {
        return this.recipeEffects;
    }

    @Generated
    public Color getColor() {
        return this.color;
    }

    public static class Builder
    implements dev.jsinco.brewery.api.util.Builder<RecipeResult<ItemStack>> {
        private boolean glint;
        private int customModelData;
        private NamespacedKey itemModel;
        private String name;
        private List<String> lore;
        private RecipeEffectsImpl recipeEffects;
        private Color color = Color.BLUE;
        private boolean appendBrewInfoLore = true;
        private BreweryKey customId;

        public Builder glint(boolean glint) {
            this.glint = glint;
            return this;
        }

        public Builder customModelData(int customModelData) {
            this.customModelData = customModelData;
            return this;
        }

        public Builder itemModel(@Nullable String itemModel) {
            if (itemModel != null) {
                this.itemModel = NamespacedKey.fromString((String)itemModel);
                if (this.itemModel == null) {
                    throw new IllegalArgumentException("Illegal namespaced key");
                }
            }
            return this;
        }

        public Builder recipeEffects(@NotNull RecipeEffectsImpl recipeEffects) {
            this.recipeEffects = Objects.requireNonNull(recipeEffects);
            return this;
        }

        public Builder color(@NotNull Color color) {
            this.color = color;
            return this;
        }

        public Builder appendBrewInfoLore(boolean appendBrewInfoLore) {
            this.appendBrewInfoLore = appendBrewInfoLore;
            return this;
        }

        public Builder customId(@Nullable String customId) {
            if (customId == null) {
                this.customId = null;
                return this;
            }
            BreweryKey namespacedKey = BreweryKey.parse(customId, "minecraft");
            List<String> ids = TheBrewingProject.getInstance().getIntegrationManager().retrieve(IntegrationTypes.ITEM).stream().map(Integration::getId).toList();
            if (ids.contains(namespacedKey.namespace()) || "minecraft".equals(namespacedKey.namespace())) {
                this.customId = namespacedKey;
                return this;
            }
            throw new IllegalArgumentException("Unknown key, can not identify namespace: " + String.valueOf(namespacedKey));
        }

        @Override
        public BukkitRecipeResult build() {
            Objects.requireNonNull(this.name, "Names not initialized, a recipe has to have names");
            Objects.requireNonNull(this.recipeEffects, "Effects not initialized, a recipe has to have effects");
            if (this.lore == null) {
                this.lore = List.of();
            }
            return new BukkitRecipeResult(this.glint, this.customModelData, this.itemModel, this.recipeEffects, this.name, this.lore, this.color, this.appendBrewInfoLore, this.customId);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder lore(List<String> lore) {
            this.lore = lore;
            return this;
        }
    }
}

