/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.listener;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.breweries.InventoryAccessible;
import dev.jsinco.brewery.api.util.CancelState;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.event.transaction.BarrelExtractEvent;
import dev.jsinco.brewery.bukkit.api.event.transaction.BarrelInsertEvent;
import dev.jsinco.brewery.bukkit.api.event.transaction.DistilleryExtractEvent;
import dev.jsinco.brewery.bukkit.api.event.transaction.DistilleryInsertEvent;
import dev.jsinco.brewery.bukkit.api.event.transaction.ItemTransactionEvent;
import dev.jsinco.brewery.bukkit.api.transaction.ItemSource;
import dev.jsinco.brewery.bukkit.api.transaction.ItemTransaction;
import dev.jsinco.brewery.bukkit.api.transaction.ItemTransactionSession;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.breweries.BreweryRegistry;
import dev.jsinco.brewery.bukkit.breweries.barrel.BukkitBarrel;
import dev.jsinco.brewery.bukkit.breweries.distillery.BukkitDistillery;
import dev.jsinco.brewery.bukkit.effect.named.PukeNamedExecutable;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.database.sql.Database;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryMoveItemEvent;
import org.bukkit.event.inventory.InventoryPickupItemEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InventoryEventListener
implements Listener {
    private final BreweryRegistry registry;
    private final Database database;
    private static final Set<InventoryAction> CLICKED_INVENTORY_ITEM_MOVE = Set.of(InventoryAction.PLACE_SOME, InventoryAction.PLACE_ONE, InventoryAction.PLACE_ALL, InventoryAction.PICKUP_ALL, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_SOME, InventoryAction.PICKUP_ONE, InventoryAction.SWAP_WITH_CURSOR);
    private static final Set<InventoryAction> CURSOR = Set.of(InventoryAction.PICKUP_ONE, InventoryAction.PICKUP_SOME, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_ALL, InventoryAction.PLACE_ONE, InventoryAction.PLACE_SOME, InventoryAction.PLACE_ALL, InventoryAction.SWAP_WITH_CURSOR);
    private static final Set<InventoryAction> ITEM_PICKUP_CURSOR = Set.of(InventoryAction.PICKUP_ONE, InventoryAction.PICKUP_SOME, InventoryAction.PICKUP_HALF, InventoryAction.PICKUP_ALL);
    private static final Set<InventoryAction> BANNED = Set.of(InventoryAction.PICKUP_FROM_BUNDLE, InventoryAction.PLACE_FROM_BUNDLE, InventoryAction.PICKUP_ALL_INTO_BUNDLE, InventoryAction.PLACE_ALL_INTO_BUNDLE, InventoryAction.PLACE_SOME_INTO_BUNDLE, InventoryAction.PICKUP_SOME_INTO_BUNDLE);

    public InventoryEventListener(BreweryRegistry registry, Database database) {
        this.registry = registry;
        this.database = database;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @EventHandler(ignoreCancelled=true)
    public void onInventoryClick(InventoryClickEvent event) {
        ItemTransactionEvent<?> transactionEvent;
        boolean upperInventoryIsClicked;
        InventoryAccessible<ItemStack, Inventory> inventoryAccessible = this.registry.getFromInventory(event.getInventory());
        if (inventoryAccessible == null) {
            return;
        }
        InventoryAction action = event.getAction();
        if (action == InventoryAction.NOTHING) {
            return;
        }
        if (BANNED.contains(action)) {
            event.setCancelled(true);
            return;
        }
        boolean bl = upperInventoryIsClicked = event.getClickedInventory() == event.getInventory();
        if (!upperInventoryIsClicked && CLICKED_INVENTORY_ITEM_MOVE.contains(action)) {
            return;
        }
        List<ItemTransactionEvent<?>> transactions = this.compileTransactionsFromClick(event, upperInventoryIsClicked, inventoryAccessible);
        Iterator<ItemTransactionEvent<?>> iterator = transactions.iterator();
        do {
            if (iterator.hasNext()) continue;
            Bukkit.getScheduler().runTask((Plugin)TheBrewingProject.getInstance(), () -> this.displayEventResult(event.getView(), transactions));
            return;
        } while ((transactionEvent = iterator.next()).callEvent());
        CancelState cancelState = transactionEvent.getCancelState();
        if (cancelState instanceof CancelState.PermissionDenied) {
            Component denyMessage;
            CancelState.PermissionDenied permissionDenied = (CancelState.PermissionDenied)cancelState;
            try {
                Component component;
                denyMessage = component = permissionDenied.message();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            event.getWhoClicked().sendMessage(denyMessage);
        }
        event.setResult(Event.Result.DENY);
    }

    private void displayEventResult(@NotNull InventoryView view, List<? extends ItemTransactionEvent<?>> transactions) {
        for (ItemTransactionEvent<?> transactionEvent : transactions) {
            int pos;
            int n;
            Record record;
            ItemTransaction.InventoryPosition inventoryPosition;
            ItemStack itemStack;
            ItemTransactionSession<?> session = transactionEvent.getTransactionSession();
            ItemTransaction transaction = session.getTransaction();
            ItemStack itemStack2 = itemStack = session.getResult() == null ? null : session.getResult().get();
            if (transaction.to() instanceof ItemTransaction.Cursor && transaction.itemStack().equals((Object)view.getCursor())) {
                view.setCursor(itemStack);
            }
            if ((inventoryPosition = transaction.to()) instanceof ItemTransaction.RawPosition) {
                record = (ItemTransaction.RawPosition)inventoryPosition;
                pos = n = ((ItemTransaction.RawPosition)record).pos();
                if (transaction.itemStack().equals((Object)view.getItem(pos))) {
                    view.setItem(pos, itemStack);
                }
            }
            if ((inventoryPosition = transaction.to()) instanceof ItemTransaction.UpperInventoryPosition) {
                record = (ItemTransaction.UpperInventoryPosition)inventoryPosition;
                pos = n = ((ItemTransaction.UpperInventoryPosition)record).pos();
                if (transaction.itemStack().equals((Object)view.getTopInventory().getItem(pos))) {
                    view.getTopInventory().setItem(pos, itemStack);
                }
            }
            if (!((inventoryPosition = transaction.to()) instanceof ItemTransaction.LowerInventoryPosition)) continue;
            record = (ItemTransaction.LowerInventoryPosition)inventoryPosition;
            try {
                pos = n = ((ItemTransaction.LowerInventoryPosition)record).pos();
            }
            catch (Throwable throwable) {
                throw new MatchException(throwable.toString(), throwable);
            }
            if (!transaction.itemStack().equals((Object)view.getBottomInventory().getItem(pos))) continue;
            view.getBottomInventory().setItem(pos, itemStack);
        }
    }

    private List<? extends ItemTransactionEvent<?>> compileTransactionsFromClick(InventoryClickEvent event, boolean upperInventoryIsClicked, InventoryAccessible<ItemStack, Inventory> inventoryAccessible) {
        Player temp;
        Player player;
        HumanEntity humanEntity = event.getWhoClicked();
        Player player2 = player = humanEntity instanceof Player ? (temp = (Player)humanEntity) : null;
        if (event.getAction() == InventoryAction.MOVE_TO_OTHER_INVENTORY) {
            if (upperInventoryIsClicked) {
                return this.findEmptyPositions(event.getView(), event.getCurrentItem(), false).stream().map(inventoryPosition -> InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.RawPosition(event.getRawSlot()), inventoryPosition, event.getCurrentItem(), false, player)).toList();
            }
            return this.findEmptyPositions(event.getView(), event.getCurrentItem(), true).stream().map(inventoryPosition -> InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.RawPosition(event.getRawSlot()), inventoryPosition, event.getCurrentItem(), true, player)).toList();
        }
        if (event.getAction() == InventoryAction.HOTBAR_SWAP) {
            ItemStack hotbarItem;
            int hotbar;
            if (!upperInventoryIsClicked) {
                return List.of();
            }
            int n = event.getHotbarButton() == -1 ? (event.getClick() == ClickType.SWAP_OFFHAND ? 40 : -1) : (hotbar = event.getHotbarButton());
            if (hotbar == -1) {
                return List.of();
            }
            ItemStack currentItem = event.getCurrentItem();
            ArrayList output = new ArrayList();
            if (currentItem != null && !currentItem.isEmpty()) {
                output.add(InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.RawPosition(event.getRawSlot()), new ItemTransaction.LowerInventoryPosition(hotbar), currentItem, false, player));
            }
            if ((hotbarItem = event.getView().getBottomInventory().getItem(hotbar)) != null && !hotbarItem.isEmpty()) {
                output.add(InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.LowerInventoryPosition(hotbar), new ItemTransaction.RawPosition(event.getRawSlot()), hotbarItem, true, player));
            }
            return output;
        }
        if (CURSOR.contains(event.getAction())) {
            if (InventoryAction.SWAP_WITH_CURSOR == event.getAction()) {
                return List.of(InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.Cursor(), new ItemTransaction.RawPosition(event.getRawSlot()), event.getCursor(), true, player), InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.RawPosition(event.getRawSlot()), new ItemTransaction.Cursor(), event.getCurrentItem(), false, player));
            }
            if (ITEM_PICKUP_CURSOR.contains(event.getAction())) {
                return List.of(InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.RawPosition(event.getRawSlot()), new ItemTransaction.Cursor(), event.getCurrentItem(), false, player));
            }
            return List.of(InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.Cursor(), new ItemTransaction.RawPosition(event.getRawSlot()), event.getCursor(), true, player));
        }
        return List.of();
    }

    private List<ItemTransaction.InventoryPosition> findEmptyPositions(InventoryView view, @Nullable ItemStack currentItem, boolean topInventory) {
        if (currentItem == null) {
            return List.of();
        }
        Inventory inventory = topInventory ? view.getTopInventory() : view.getBottomInventory();
        int amount = currentItem.getAmount();
        int size = view.getTopInventory().getSize() + 36;
        ArrayList<ItemTransaction.InventoryPosition> positions = new ArrayList<ItemTransaction.InventoryPosition>();
        for (int i = 0; i < size; ++i) {
            int rawPos = topInventory ? i : size - 1 - i;
            if (inventory != view.getInventory(rawPos)) continue;
            ItemStack item = view.getItem(rawPos);
            if (item == null || item.isEmpty()) {
                positions.add(new ItemTransaction.RawPosition(rawPos));
                return positions;
            }
            if (!item.isSimilar(currentItem) || item.getMaxStackSize() <= item.getAmount()) continue;
            positions.add(new ItemTransaction.RawPosition(rawPos));
            if ((amount -= item.getMaxStackSize() - item.getAmount()) <= 0) break;
        }
        return positions;
    }

    private static ItemTransactionEvent<?> eventFromStructure(InventoryAccessible<ItemStack, Inventory> inventoryAccessible, ItemTransaction.InventoryPosition from, ItemTransaction.InventoryPosition to, ItemStack item, boolean insertion, @Nullable Player player) {
        ItemTransaction transaction = new ItemTransaction(from, to, item, insertion);
        Optional<Brew> brewOptional = BrewAdapter.fromItem(item).map(inventoryAccessible::initializeBrew);
        if (player != null) {
            brewOptional = brewOptional.map(brew -> brew.witModifiedLastStep(step -> {
                BrewingStep.AuthoredStep authoredStep;
                return step instanceof BrewingStep.AuthoredStep && !(authoredStep = (BrewingStep.AuthoredStep)step).isCompleted() ? authoredStep.withBrewersReplaced(new LinkedList<UUID>()) : step;
            })).map(brew -> brew.witModifiedLastStep(step -> {
                BrewingStep brewingStep;
                if (step instanceof BrewingStep.AuthoredStep) {
                    BrewingStep.AuthoredStep authoredStep = (BrewingStep.AuthoredStep)step;
                    brewingStep = authoredStep.withBrewer(player.getUniqueId());
                } else {
                    brewingStep = step;
                }
                return brewingStep;
            }));
        }
        if (inventoryAccessible instanceof BukkitDistillery) {
            BukkitDistillery distillery = (BukkitDistillery)inventoryAccessible;
            Record cancelState = brewOptional.isEmpty() ? new CancelState.Cancelled() : (player == null || player.hasPermission("brewery.distillery.access") ? new CancelState.Allowed() : new CancelState.PermissionDenied((Component)Component.translatable((String)"tbp.distillery.access-denied")));
            return insertion ? new DistilleryInsertEvent(distillery, new ItemTransactionSession<ItemSource.BrewBasedSource>(transaction, brewOptional.map(brew -> new ItemSource.BrewBasedSource((Brew)brew, new Brew.State.Brewing())).orElse(null)), (CancelState)((Object)cancelState), player) : new DistilleryExtractEvent(distillery, new ItemTransactionSession<ItemSource.ItemBasedSource>(transaction, brewOptional.map(brew -> BrewAdapter.toItem(brew, new Brew.State.Other())).map(ItemSource.ItemBasedSource::new).orElse(null)), (CancelState)((Object)cancelState), player);
        }
        if (inventoryAccessible instanceof BukkitBarrel) {
            BukkitBarrel barrel = (BukkitBarrel)inventoryAccessible;
            Record cancelState = brewOptional.isEmpty() ? new CancelState.Cancelled() : (player == null || player.hasPermission("brewery.barrel.access") ? new CancelState.Allowed() : new CancelState.PermissionDenied((Component)Component.translatable((String)"tbp.barrel.access-denied")));
            return insertion ? new BarrelInsertEvent(barrel, new ItemTransactionSession<ItemSource.BrewBasedSource>(transaction, brewOptional.map(brew -> new ItemSource.BrewBasedSource((Brew)brew, new Brew.State.Brewing())).orElse(null)), (CancelState)((Object)cancelState), player) : new BarrelExtractEvent(barrel, new ItemTransactionSession<ItemSource.ItemBasedSource>(transaction, brewOptional.map(brew -> BrewAdapter.toItem(brew, new Brew.State.Other())).map(ItemSource.ItemBasedSource::new).orElse(null)), (CancelState)((Object)cancelState), player);
        }
        throw new IllegalStateException("Unknown structure: " + String.valueOf(inventoryAccessible));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryDrag(InventoryDragEvent dragEvent) {
        InventoryAccessible<ItemStack, Inventory> inventoryAccessible = this.registry.getFromInventory(dragEvent.getInventory());
        if (inventoryAccessible == null) {
            return;
        }
        InventoryView inventoryView = dragEvent.getView();
        List<ItemTransactionEvent> transactionEvents = dragEvent.getNewItems().entrySet().stream().filter(entry -> dragEvent.getInventory() == inventoryView.getInventory(((Integer)entry.getKey()).intValue())).map(entry -> {
            Player player;
            HumanEntity patt0$temp;
            return InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.Cursor(), new ItemTransaction.RawPosition((Integer)entry.getKey()), (ItemStack)entry.getValue(), true, (patt0$temp = dragEvent.getWhoClicked()) instanceof Player ? (player = (Player)patt0$temp) : null);
        }).toList();
        List<CancelState> cancelled = transactionEvents.stream().filter(transactionEvent -> !transactionEvent.callEvent()).map(ItemTransactionEvent::getCancelState).toList();
        if (!cancelled.isEmpty()) {
            cancelled.stream().filter(CancelState.PermissionDenied.class::isInstance).map(CancelState.PermissionDenied.class::cast).map(CancelState.PermissionDenied::message).forEach(arg_0 -> ((HumanEntity)dragEvent.getWhoClicked()).sendMessage(arg_0));
            dragEvent.setCancelled(true);
            return;
        }
        Bukkit.getScheduler().runTask((Plugin)TheBrewingProject.getInstance(), () -> this.displayEventResult(inventoryView, transactionEvents));
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryMoveItem(InventoryMoveItemEvent event) {
        Optional<InventoryAccessible<ItemStack, Inventory>> source = Optional.ofNullable(this.registry.getFromInventory(event.getSource()));
        Optional<InventoryAccessible<ItemStack, Inventory>> destination = Optional.ofNullable(this.registry.getFromInventory(event.getDestination()));
        Optional<InventoryAccessible<ItemStack, Inventory>> both = destination.or(() -> source);
        if (!Config.config().automation()) {
            both.ifPresent(ignored -> event.setCancelled(true));
            return;
        }
        if (both.isEmpty()) {
            return;
        }
        InventoryAccessible<ItemStack, Inventory> inventoryAccessible = both.get();
        ItemTransactionEvent<?> transactionEvent = InventoryEventListener.eventFromStructure(inventoryAccessible, new ItemTransaction.FirstInventoryPosition(source.isPresent()), new ItemTransaction.FirstInventoryPosition(destination.isPresent()), event.getItem(), destination.isPresent(), null);
        if (!transactionEvent.callEvent()) {
            event.setCancelled(true);
            return;
        }
        Object result = transactionEvent.getTransactionSession().getResult();
        if (result == null) {
            event.setCancelled(true);
            return;
        }
        event.setItem(result.get());
    }

    @EventHandler(ignoreCancelled=true)
    public void onInventoryPickupItem(InventoryPickupItemEvent event) {
        if (event.getItem().getPersistentDataContainer().has(PukeNamedExecutable.PUKE_ITEM)) {
            event.setCancelled(true);
        }
    }
}

