/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.listener;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.breweries.Cauldron;
import dev.jsinco.brewery.api.breweries.InventoryAccessible;
import dev.jsinco.brewery.api.breweries.StructureHolder;
import dev.jsinco.brewery.api.structure.BlockMatcherReplacement;
import dev.jsinco.brewery.api.structure.MultiblockStructure;
import dev.jsinco.brewery.api.structure.SinglePositionStructure;
import dev.jsinco.brewery.api.structure.StructureMeta;
import dev.jsinco.brewery.api.structure.StructureType;
import dev.jsinco.brewery.api.util.CancelState;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.api.event.structure.BarrelDestroyEvent;
import dev.jsinco.brewery.bukkit.api.event.structure.CauldronDestroyEvent;
import dev.jsinco.brewery.bukkit.api.event.structure.DistilleryDestroyEvent;
import dev.jsinco.brewery.bukkit.breweries.BreweryRegistry;
import dev.jsinco.brewery.bukkit.breweries.barrel.BukkitBarrel;
import dev.jsinco.brewery.bukkit.breweries.barrel.BukkitBarrelDataType;
import dev.jsinco.brewery.bukkit.breweries.distillery.BukkitDistillery;
import dev.jsinco.brewery.bukkit.breweries.distillery.BukkitDistilleryDataType;
import dev.jsinco.brewery.bukkit.listener.ListenerUtil;
import dev.jsinco.brewery.bukkit.structure.BarrelBlockDataMatcher;
import dev.jsinco.brewery.bukkit.structure.BreweryStructure;
import dev.jsinco.brewery.bukkit.structure.GenericBlockDataMatcher;
import dev.jsinco.brewery.bukkit.structure.PlacedBreweryStructure;
import dev.jsinco.brewery.bukkit.structure.StructureRegistry;
import dev.jsinco.brewery.bukkit.util.LocationUtil;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.database.PersistenceException;
import dev.jsinco.brewery.database.sql.Database;
import dev.jsinco.brewery.structure.PlacedStructureRegistryImpl;
import dev.jsinco.brewery.util.MessageUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.ExplosionResult;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.type.WallSign;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockBurnEvent;
import org.bukkit.event.block.BlockExplodeEvent;
import org.bukkit.event.block.BlockPistonExtendEvent;
import org.bukkit.event.block.BlockPistonRetractEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.block.SignChangeEvent;
import org.bukkit.event.entity.EntityChangeBlockEvent;
import org.bukkit.event.entity.EntityExplodeEvent;
import org.bukkit.event.inventory.HopperInventorySearchEvent;
import org.jetbrains.annotations.Nullable;

public class BlockEventListener
implements Listener {
    private final StructureRegistry structureRegistry;
    private final PlacedStructureRegistryImpl placedStructureRegistry;
    private final Database database;
    private final BreweryRegistry breweryRegistry;

    public BlockEventListener(StructureRegistry structureRegistry, PlacedStructureRegistryImpl placedStructureRegistry, Database database, BreweryRegistry breweryRegistry) {
        this.structureRegistry = structureRegistry;
        this.placedStructureRegistry = placedStructureRegistry;
        this.database = database;
        this.breweryRegistry = breweryRegistry;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onSignChangeEvent(SignChangeEvent event) {
        Set keywords = Config.config().barrels().signKeywords().stream().map(String::toLowerCase).collect(Collectors.toSet());
        String firstLine = PlainTextComponentSerializer.plainText().serialize((Component)event.lines().getFirst()).toLowerCase();
        if (Config.config().barrels().requireSignKeyword() && !keywords.contains(firstLine)) {
            return;
        }
        BlockData blockData = event.getBlock().getBlockData();
        if (!(blockData instanceof WallSign)) {
            return;
        }
        WallSign wallSign = (WallSign)blockData;
        Optional<Pair<PlacedBreweryStructure<BukkitBarrel>, BarrelType>> possibleStructure = this.getBarrel(event.getBlock().getRelative(wallSign.getFacing().getOppositeFace()));
        if (possibleStructure.isEmpty()) {
            return;
        }
        Pair<PlacedBreweryStructure<BukkitBarrel>, BarrelType> placedStructurePair = possibleStructure.get();
        PlacedBreweryStructure<BukkitBarrel> placedBreweryStructure = placedStructurePair.first();
        if (!this.placedStructureRegistry.getStructures(placedBreweryStructure.positions()).isEmpty()) {
            return;
        }
        if (!event.getPlayer().hasPermission("brewery.barrel.create")) {
            MessageUtil.message((Audience)event.getPlayer(), "tbp.barrel.create-denied", new TagResolver[0]);
            return;
        }
        MessageUtil.message((Audience)event.getPlayer(), "tbp.barrel.create", new TagResolver[0]);
        BukkitBarrel barrel = new BukkitBarrel(BukkitAdapter.toLocation(placedBreweryStructure.getUnique()).orElseThrow(), placedBreweryStructure, placedBreweryStructure.getStructure().getMeta(StructureMeta.INVENTORY_SIZE), placedStructurePair.second());
        placedBreweryStructure.setHolder(barrel);
        this.placedStructureRegistry.registerStructure(placedBreweryStructure);
        this.breweryRegistry.registerInventory(barrel);
        try {
            this.database.insertValue(BukkitBarrelDataType.INSTANCE, barrel);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    @EventHandler(ignoreCancelled=true, priority=EventPriority.MONITOR)
    public void onBlockPlace(BlockPlaceEvent placeEvent) {
        Block placed = placeEvent.getBlockPlaced();
        for (BreweryStructure breweryStructure : this.structureRegistry.getPossibleStructures(placed.getType(), StructureType.DISTILLERY)) {
            Optional placedBreweryStructureOptional = PlacedBreweryStructure.findValid(breweryStructure, placed.getLocation(), new GenericBlockDataMatcher(breweryStructure.getMetaOrDefault(StructureMeta.BLOCK_REPLACEMENTS, new BlockMatcherReplacement.List()).elements()), new Void[1]);
            if (!placedBreweryStructureOptional.isPresent() || !this.placedStructureRegistry.getStructures(placedBreweryStructureOptional.get().first().positions()).isEmpty()) continue;
            Player player = placeEvent.getPlayer();
            if (!player.hasPermission("brewery.distillery.create")) {
                MessageUtil.message((Audience)player, "tbp.distillery.create-denied", new TagResolver[0]);
                return;
            }
            this.registerDistillery(placedBreweryStructureOptional.get().first());
            MessageUtil.message((Audience)player, "tbp.distillery.create", new TagResolver[0]);
            return;
        }
    }

    private void registerDistillery(PlacedBreweryStructure<BukkitDistillery> distilleryPlacedBreweryStructure) {
        BukkitDistillery bukkitDistillery = new BukkitDistillery(distilleryPlacedBreweryStructure);
        distilleryPlacedBreweryStructure.setHolder(bukkitDistillery);
        this.placedStructureRegistry.registerStructure(distilleryPlacedBreweryStructure);
        try {
            this.database.insertValue(BukkitDistilleryDataType.INSTANCE, bukkitDistillery);
            this.breweryRegistry.registerInventory(bukkitDistillery);
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    private Optional<Pair<PlacedBreweryStructure<BukkitBarrel>, BarrelType>> getBarrel(Block block) {
        Location placedLocation = block.getLocation();
        Material material = block.getType();
        Set<BreweryStructure> possibleStructures = this.structureRegistry.getPossibleStructures(material, StructureType.BARREL);
        for (BreweryStructure structure : possibleStructures) {
            Optional<Pair<PlacedBreweryStructure<BukkitBarrel>, BarrelType>> placedBreweryStructure = PlacedBreweryStructure.findValid(structure, placedLocation, BarrelBlockDataMatcher.INSTANCE, BarrelType.PLACEABLE_TYPES);
            if (!placedBreweryStructure.isPresent()) continue;
            return placedBreweryStructure;
        }
        return Optional.empty();
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        boolean success = this.destroyFromBlock(event.getBlock(), event.getPlayer());
        if (!success) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonExtend(BlockPistonExtendEvent event) {
        boolean success = this.onMultiBlockRemove(event.getBlocks().stream().map(Block::getLocation).toList(), null);
        if (!success) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPistonRetract(BlockPistonRetractEvent event) {
        boolean success = this.onMultiBlockRemove(event.getBlocks().stream().map(Block::getLocation).toList(), null);
        if (!success) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onEntityExplode(EntityExplodeEvent event) {
        if (event.getExplosionResult() == ExplosionResult.TRIGGER_BLOCK) {
            return;
        }
        boolean success = this.onMultiBlockRemove(event.blockList().stream().map(Block::getLocation).toList(), null);
        if (!success) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockExplode(BlockExplodeEvent event) {
        if (event.getExplosionResult() == ExplosionResult.TRIGGER_BLOCK) {
            return;
        }
        boolean success = this.onMultiBlockRemove(event.blockList().stream().map(Block::getLocation).toList(), null);
        if (!success) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onBlockBurn(BlockBurnEvent event) {
        boolean success = this.destroyFromBlock(event.getBlock(), null);
        if (!success) {
            event.setCancelled(true);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onEntityChangeBlock(EntityChangeBlockEvent event) {
        Player p;
        Entity entity = event.getEntity();
        Player player = entity instanceof Player ? (p = (Player)entity) : null;
        boolean success = this.destroyFromBlock(event.getBlock(), player);
        if (!success) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onHopperInventorySearch(HopperInventorySearchEvent event) {
        Block searchBlock = event.getSearchBlock();
        BreweryLocation breweryLocation = BukkitAdapter.toBreweryLocation(searchBlock);
        Optional<InventoryAccessible> inventoryAccessibleOptional = this.placedStructureRegistry.getStructure(breweryLocation).map(MultiblockStructure::getHolder).filter(InventoryAccessible.class::isInstance).map(inventoryAccessible -> (InventoryAccessible)((Object)inventoryAccessible));
        if (!Config.config().automation()) {
            inventoryAccessibleOptional.ifPresent(ignored -> event.setInventory(null));
            return;
        }
        inventoryAccessibleOptional.flatMap(inventoryAccessible -> inventoryAccessible.access(breweryLocation)).ifPresent(arg_0 -> ((HopperInventorySearchEvent)event).setInventory(arg_0));
    }

    private boolean destroyFromBlock(Block block, @Nullable Player player) {
        return this.onMultiBlockRemove(List.of(block.getLocation()), player);
    }

    private boolean onMultiBlockRemove(List<Location> locations, @Nullable Player player) {
        if (locations.isEmpty()) {
            return true;
        }
        HashSet singlePositionStructures = new HashSet();
        HashSet multiblockStructures = new HashSet();
        HashMap holdersToDrops = new HashMap();
        for (Location location : locations) {
            BreweryLocation breweryLocation = BukkitAdapter.toBreweryLocation(location);
            Optional<SinglePositionStructure> single = this.breweryRegistry.getActiveSinglePositionStructure(breweryLocation).filter(singlePositionStructure -> !singlePositionStructures.contains(singlePositionStructure));
            CancelState cancelState = single.map(singlePositionStructure -> BlockEventListener.callSinglePositionStructureEvent(location, player, singlePositionStructure)).orElseGet(CancelState.Allowed::new);
            if (BlockEventListener.actOnCancelState(cancelState, (Audience)player)) {
                return false;
            }
            single.ifPresent(singlePositionStructures::add);
            Optional<StructureHolder> structureHolderOptional = this.placedStructureRegistry.getHolder(breweryLocation).filter(structureHolder -> !multiblockStructures.contains(structureHolder.getStructure()));
            Result result = structureHolderOptional.map(holder -> BlockEventListener.callPlacedStructureEvent(location, player, holder)).orElseGet(() -> new Result(new CancelState.Allowed(), List.of()));
            if (BlockEventListener.actOnCancelState(result.cancelState(), (Audience)player)) {
                return false;
            }
            structureHolderOptional.ifPresent(holder -> {
                holdersToDrops.put(holder, result.drops);
                multiblockStructures.add(holder.getStructure());
            });
        }
        singlePositionStructures.forEach(structure -> ListenerUtil.removeActiveSinglePositionStructure(structure, this.breweryRegistry, this.database));
        multiblockStructures.forEach(this.placedStructureRegistry::unregisterStructure);
        Location location = locations.getFirst();
        for (Map.Entry entry : holdersToDrops.entrySet()) {
            StructureHolder holder2 = (StructureHolder)entry.getKey();
            List drops = (List)entry.getValue();
            if (holder2 instanceof InventoryAccessible) {
                InventoryAccessible inventoryAccessible = (InventoryAccessible)((Object)holder2);
                this.breweryRegistry.unregisterInventory(inventoryAccessible);
            }
            this.remove(holder2);
            LocationUtil.dropBrews(location, (List<Brew>)drops);
        }
        return true;
    }

    private static boolean actOnCancelState(CancelState cancelState, @Nullable Audience audience) {
        if (cancelState instanceof CancelState.PermissionDenied) {
            CancelState.PermissionDenied permissionDenied = (CancelState.PermissionDenied)cancelState;
            permissionDenied.sendMessage(audience);
            return true;
        }
        return cancelState instanceof CancelState.Cancelled;
    }

    private static CancelState callSinglePositionStructureEvent(Location location, @Nullable Player player, SinglePositionStructure structure) {
        if (structure instanceof Cauldron) {
            Cauldron cauldron = (Cauldron)structure;
            CauldronDestroyEvent event = new CauldronDestroyEvent((CancelState)((Object)(player == null || player.hasPermission("brewery.cauldron.access") ? new CancelState.Allowed() : new CancelState.PermissionDenied((Component)Component.translatable((String)"tbp.cauldron.access-denied")))), cauldron, player, location);
            event.callEvent();
            return event.getCancelState();
        }
        return new CancelState.Allowed();
    }

    private static Result callPlacedStructureEvent(Location location, @Nullable Player player, StructureHolder<?> holder) {
        StructureHolder<?> structureHolder = holder;
        Objects.requireNonNull(structureHolder);
        StructureHolder<?> structureHolder2 = structureHolder;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BukkitBarrel.class, BukkitDistillery.class}, structureHolder2, n)) {
            case 0 -> {
                BukkitBarrel barrel = (BukkitBarrel)structureHolder2;
                BarrelDestroyEvent event = new BarrelDestroyEvent((CancelState)((Object)(player == null || player.hasPermission("brewery.barrel.access") ? new CancelState.Allowed() : new CancelState.PermissionDenied((Component)Component.translatable((String)"tbp.barrel.access-denied")))), barrel, player, location, barrel.calculateDestroyDrops());
                event.callEvent();
                yield new Result(event.getCancelState(), event.getDrops());
            }
            case 1 -> {
                BukkitDistillery distillery = (BukkitDistillery)structureHolder2;
                DistilleryDestroyEvent event = new DistilleryDestroyEvent((CancelState)((Object)(player == null || player.hasPermission("brewery.distillery.access") ? new CancelState.Allowed() : new CancelState.PermissionDenied((Component)Component.translatable((String)"tbp.distillery.access-denied")))), distillery, player, location, distillery.calculateDestroyDrops());
                event.callEvent();
                yield new Result(event.getCancelState(), event.getDrops());
            }
            default -> new Result(new CancelState.Allowed(), Collections.emptyList());
        };
    }

    private void remove(StructureHolder<?> holder) {
        try {
            StructureHolder<?> structureHolder = holder;
            Objects.requireNonNull(structureHolder);
            StructureHolder<?> structureHolder2 = structureHolder;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BukkitBarrel.class, BukkitDistillery.class}, structureHolder2, n)) {
                case 0: {
                    BukkitBarrel barrel = (BukkitBarrel)structureHolder2;
                    barrel.destroyWithoutDrops();
                    this.database.remove(BukkitBarrelDataType.INSTANCE, barrel);
                    break;
                }
                case 1: {
                    BukkitDistillery distillery = (BukkitDistillery)structureHolder2;
                    distillery.destroyWithoutDrops();
                    this.database.remove(BukkitDistilleryDataType.INSTANCE, distillery);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown structure type");
                }
            }
        }
        catch (PersistenceException e) {
            Logger.logErr(e);
        }
    }

    private record Result(CancelState cancelState, List<Brew> drops) {
    }
}

