/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.structure;

import dev.jsinco.brewery.api.structure.MultiblockStructure;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.api.integration.StructureIntegration;
import dev.jsinco.brewery.util.ClassUtil;
import java.util.Collection;
import java.util.Optional;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.popcraft.bolt.BoltAPI;

public class BoltIntegration
implements StructureIntegration {
    private static final boolean ENABLED = ClassUtil.exists("org.popcraft.bolt.BoltAPI");
    private static BoltAPI boltAPI;

    @Override
    public boolean hasAccess(Block block, Player player, BreweryKey type) {
        if (!ENABLED) {
            return true;
        }
        if (boltAPI == null) {
            return true;
        }
        Optional<MultiblockStructure<?>> multiBlockStructureOptional = TheBrewingProject.getInstance().getPlacedStructureRegistry().getStructure(BukkitAdapter.toBreweryLocation(block));
        return multiBlockStructureOptional.stream().map(MultiblockStructure::positions).flatMap(Collection::stream).map(BukkitAdapter::toBlock).flatMap(Optional::stream).allMatch(position -> boltAPI.canAccess(position, player, new String[0])) && boltAPI.canAccess(block, player, new String[0]);
    }

    @Override
    public boolean isEnabled() {
        return ENABLED;
    }

    @Override
    public String getId() {
        return "bolt";
    }

    @Override
    public void onEnable() {
        if (!ENABLED) {
            return;
        }
        boltAPI = (BoltAPI)Bukkit.getServer().getServicesManager().load(BoltAPI.class);
    }
}

