/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration.event;

import dev.geco.gsit.api.GSitAPI;
import dev.geco.gsit.api.event.PreEntityStopSitEvent;
import dev.geco.gsit.api.event.PrePlayerStopCrawlEvent;
import dev.geco.gsit.api.event.PrePlayerStopPoseEvent;
import dev.geco.gsit.model.Crawl;
import dev.geco.gsit.model.Pose;
import dev.geco.gsit.model.PoseType;
import dev.geco.gsit.model.Seat;
import dev.geco.gsit.model.StopReason;
import dev.jsinco.brewery.api.event.EventData;
import dev.jsinco.brewery.api.event.EventProbability;
import dev.jsinco.brewery.api.event.IntegrationEvent;
import dev.jsinco.brewery.api.meta.MetaDataType;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.api.integration.EventIntegration;
import dev.jsinco.brewery.util.ClassUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class GSitIntegration
implements EventIntegration<GSitEvent>,
Listener {
    private static final String GSIT = "gsit";

    @Override
    public Class<GSitEvent> eClass() {
        return GSitEvent.class;
    }

    @Override
    public List<BreweryKey> listEventKeys() {
        ArrayList<BreweryKey> output = new ArrayList<BreweryKey>();
        for (PoseType poseType : PoseType.values()) {
            output.add(BreweryKey.parse(poseType.name(), GSIT));
        }
        output.add(BreweryKey.parse("crawl", GSIT));
        output.add(BreweryKey.parse("sit", GSIT));
        return output;
    }

    @Override
    public Optional<GSitEvent> convertToEvent(EventData event) {
        long duration;
        try {
            Long temp = event.data(EventData.DURATION_KEY, MetaDataType.STRING_TO_LONG);
            duration = temp == null ? 20L : temp;
        }
        catch (Exception e) {
            duration = 20L;
        }
        for (PoseType poseType : PoseType.values()) {
            if (!event.key().equals(BreweryKey.parse(poseType.name(), GSIT))) continue;
            return Optional.of(new GSitPoseEvent(poseType, duration));
        }
        if (event.key().equals(BreweryKey.parse("crawl", GSIT))) {
            return Optional.of(new GSitCrawlEvent(duration));
        }
        if (event.key().equals(BreweryKey.parse("sit", GSIT))) {
            return Optional.of(new GSitSitEvent(duration));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public EventData convertToData(GSitEvent event) {
        EventData eventData;
        GSitEvent gSitEvent = event;
        Objects.requireNonNull(gSitEvent);
        GSitEvent gSitEvent2 = gSitEvent;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GSitCrawlEvent.class, GSitPoseEvent.class, GSitSitEvent.class}, (Object)gSitEvent2, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                GSitCrawlEvent gSitCrawlEvent = (GSitCrawlEvent)gSitEvent2;
                try {
                    long l;
                    long duration = l = gSitCrawlEvent.duration();
                    eventData = new EventData(event.key()).withData(EventData.DURATION_KEY, MetaDataType.STRING_TO_LONG, duration);
                    return eventData;
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
            }
            case 1: {
                GSitPoseEvent gSitPoseEvent = (GSitPoseEvent)gSitEvent2;
                {
                    long l;
                    PoseType poseType;
                    PoseType ignored = poseType = gSitPoseEvent.poseType();
                    long duration = l = gSitPoseEvent.duration();
                    eventData = new EventData(event.key()).withData(EventData.DURATION_KEY, MetaDataType.STRING_TO_LONG, duration);
                    return eventData;
                }
            }
            case 2: 
        }
        GSitSitEvent gSitSitEvent = (GSitSitEvent)gSitEvent2;
        {
            long l;
            long duration = l = gSitSitEvent.duration();
            eventData = new EventData(event.key()).withData(EventData.DURATION_KEY, MetaDataType.STRING_TO_LONG, duration);
        }
        return eventData;
    }

    @Override
    public String getId() {
        return GSIT;
    }

    @Override
    public boolean isEnabled() {
        return ClassUtil.exists("dev.geco.gsit.api.GSitAPI");
    }

    @Override
    public void onEnable() {
        Bukkit.getPluginManager().registerEvents((Listener)this, (Plugin)TheBrewingProject.getInstance());
    }

    @EventHandler
    public void onPreStopPose(PrePlayerStopPoseEvent stopPoseEvent) {
        if (stopPoseEvent.getReason() == StopReason.GET_UP && GSitPoseEvent.active.contains(stopPoseEvent.getPose())) {
            stopPoseEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onPreStopPose(PrePlayerStopCrawlEvent stopCrawlEvent) {
        if (stopCrawlEvent.getReason() == StopReason.GET_UP && GSitCrawlEvent.active.contains(stopCrawlEvent.getCrawl())) {
            stopCrawlEvent.setCancelled(true);
        }
    }

    @EventHandler
    public void onPreStopSit(PreEntityStopSitEvent stopSitEvent) {
        if (stopSitEvent.getReason() == StopReason.GET_UP && GSitSitEvent.active.contains(stopSitEvent.getSeat())) {
            stopSitEvent.setCancelled(true);
        }
    }

    public static sealed interface GSitEvent
    extends IntegrationEvent
    permits GSitPoseEvent, GSitCrawlEvent, GSitSitEvent {
        @Override
        default public void run(Holder.Player player) {
            BukkitAdapter.toPlayer(player).ifPresent(this::run);
        }

        public void run(Player var1);
    }

    public record GSitPoseEvent(PoseType poseType, long duration) implements GSitEvent
    {
        private static final Set<Pose> active = new HashSet<Pose>();

        @Override
        public void run(Player player) {
            if (GSitAPI.isPlayerPosing((Player)player)) {
                return;
            }
            Pose pose = GSitAPI.createPose((Block)player.getLocation().getBlock().getRelative(BlockFace.DOWN), (Player)player, (PoseType)this.poseType);
            if (pose == null) {
                return;
            }
            active.add(pose);
            player.getScheduler().runDelayed((Plugin)TheBrewingProject.getInstance(), ignored -> {
                GSitAPI.removePose((Pose)pose, (StopReason)StopReason.PLUGIN);
                active.remove(pose);
            }, () -> active.remove(pose), this.duration);
        }

        @Override
        public BreweryKey key() {
            return BreweryKey.parse(this.poseType.name(), GSitIntegration.GSIT);
        }

        @Override
        public Component displayName() {
            return Component.translatable((String)("tbp.integration.gsit.pose." + this.poseType.name().toLowerCase(Locale.ROOT)));
        }

        @Override
        public EventProbability probability() {
            return EventProbability.NONE;
        }
    }

    public record GSitCrawlEvent(long duration) implements GSitEvent
    {
        private static final Set<Crawl> active = new HashSet<Crawl>();

        @Override
        public void run(Player player) {
            if (GSitAPI.isPlayerCrawling((Player)player)) {
                return;
            }
            Crawl crawl = GSitAPI.startCrawl((Player)player);
            if (crawl == null) {
                return;
            }
            active.add(crawl);
            player.getScheduler().runDelayed((Plugin)TheBrewingProject.getInstance(), ignored -> {
                GSitAPI.stopCrawl((Crawl)crawl, (StopReason)StopReason.PLUGIN);
                active.remove(crawl);
            }, () -> active.remove(crawl), this.duration);
        }

        @Override
        public BreweryKey key() {
            return BreweryKey.parse("crawl", GSitIntegration.GSIT);
        }

        @Override
        public Component displayName() {
            return Component.translatable((String)"tbp.integration.gsit.crawl");
        }

        @Override
        public EventProbability probability() {
            return EventProbability.NONE;
        }
    }

    public record GSitSitEvent(long duration) implements GSitEvent
    {
        private static final Set<Seat> active = new HashSet<Seat>();

        @Override
        public void run(Player player) {
            if (GSitAPI.isEntitySitting((LivingEntity)player)) {
                return;
            }
            Seat seat = GSitAPI.createSeat((Block)player.getLocation().getBlock().getRelative(BlockFace.DOWN), (LivingEntity)player);
            if (seat == null) {
                return;
            }
            active.add(seat);
            player.getScheduler().runDelayed((Plugin)TheBrewingProject.getInstance(), ignored -> {
                active.remove(seat);
                GSitAPI.removeSeat((Seat)seat, (StopReason)StopReason.PLUGIN);
            }, () -> active.remove(seat), this.duration);
        }

        @Override
        public BreweryKey key() {
            return BreweryKey.parse("sit", GSitIntegration.GSIT);
        }

        @Override
        public Component displayName() {
            return Component.translatable((String)"tbp.integration.gsit.sit");
        }

        @Override
        public EventProbability probability() {
            return EventProbability.NONE;
        }
    }
}

