/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration;

import dev.jsinco.brewery.api.integration.Integration;
import dev.jsinco.brewery.api.integration.IntegrationType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.ApiStatus;

public class IntegrationRegistry {
    private final Map<IntegrationType<?>, Set<? extends Integration>> integrations = new HashMap();

    public <T extends Integration> void register(IntegrationType<? extends T> type, T integration) {
        Set integrationSet = this.integrations.computeIfAbsent(type, k -> new HashSet());
        if (!type.integrationClass().isInstance(integration)) {
            throw new IllegalArgumentException("Cannot register integration, class " + integration.getClass().getName() + " doesn't implement " + type.integrationClass().getName());
        }
        if (integrationSet.stream().anyMatch(existingIntegration -> existingIntegration.getId().equals(integration.getId()))) {
            throw new IllegalStateException("Integration " + String.valueOf(type) + " already registered");
        }
        Set rawIntegrationList = integrationSet;
        rawIntegrationList.add(integration);
    }

    @ApiStatus.Internal
    public <T extends Integration> Set<T> getIntegrations(IntegrationType<T> type) {
        Set<? extends Integration> rawSet = this.integrations.get(type);
        if (rawSet == null) {
            return Collections.emptySet();
        }
        return this.integrations.get(type);
    }

    @ApiStatus.Internal
    public Set<? extends Integration> getAllIntegrations() {
        return this.integrations.values().stream().flatMap(Collection::stream).collect(Collectors.toSet());
    }

    @ApiStatus.Internal
    public void clear() {
        this.integrations.clear();
    }
}

