/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.integration;

import dev.jsinco.brewery.api.integration.Integration;
import dev.jsinco.brewery.api.integration.IntegrationManager;
import dev.jsinco.brewery.api.integration.IntegrationType;
import dev.jsinco.brewery.api.util.Logger;
import dev.jsinco.brewery.bukkit.api.integration.IntegrationTypes;
import dev.jsinco.brewery.bukkit.integration.IntegrationRegistry;
import dev.jsinco.brewery.bukkit.integration.chest_shop.QuickShopHikariIntegration;
import dev.jsinco.brewery.bukkit.integration.event.GSitIntegration;
import dev.jsinco.brewery.bukkit.integration.item.CraftEngineIntegration;
import dev.jsinco.brewery.bukkit.integration.item.ItemsAdderIntegration;
import dev.jsinco.brewery.bukkit.integration.item.MmoItemsIntegration;
import dev.jsinco.brewery.bukkit.integration.item.MythicIntegration;
import dev.jsinco.brewery.bukkit.integration.item.NexoIntegration;
import dev.jsinco.brewery.bukkit.integration.item.OraxenIntegration;
import dev.jsinco.brewery.bukkit.integration.placeholder.MiniPlaceholdersIntegration;
import dev.jsinco.brewery.bukkit.integration.placeholder.PlaceholderApiIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.BoltIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.GriefDefenderIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.GriefPreventionIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.HuskClaimsIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.LandsIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.TownyIntegration;
import dev.jsinco.brewery.bukkit.integration.structure.WorldGuardIntegration;
import java.util.Set;
import lombok.Generated;

public class IntegrationManagerImpl
implements IntegrationManager {
    private final IntegrationRegistry integrationRegistry = new IntegrationRegistry();

    public void registerIntegrations() {
        this.register(IntegrationTypes.STRUCTURE, new WorldGuardIntegration());
        this.register(IntegrationTypes.STRUCTURE, new BoltIntegration());
        this.register(IntegrationTypes.STRUCTURE, new GriefPreventionIntegration());
        this.register(IntegrationTypes.STRUCTURE, new HuskClaimsIntegration());
        this.register(IntegrationTypes.STRUCTURE, new LandsIntegration());
        this.register(IntegrationTypes.STRUCTURE, new TownyIntegration());
        this.register(IntegrationTypes.STRUCTURE, new GriefDefenderIntegration());
        this.register(IntegrationTypes.ITEM, new CraftEngineIntegration());
        this.register(IntegrationTypes.ITEM, new ItemsAdderIntegration());
        this.register(IntegrationTypes.ITEM, new NexoIntegration());
        this.register(IntegrationTypes.ITEM, new OraxenIntegration());
        this.register(IntegrationTypes.ITEM, new MmoItemsIntegration());
        this.register(IntegrationTypes.ITEM, new MythicIntegration());
        this.register(IntegrationTypes.PLACEHOLDER, new PlaceholderApiIntegration());
        this.register(IntegrationTypes.PLACEHOLDER, new MiniPlaceholdersIntegration());
        this.register(IntegrationTypes.CHEST_SHOP, new QuickShopHikariIntegration());
        this.register(IntegrationTypes.EVENT, new GSitIntegration());
    }

    public void loadIntegrations() {
        this.integrationRegistry.getAllIntegrations().forEach(Integration::onLoad);
    }

    public void enableIntegrations() {
        this.integrationRegistry.getAllIntegrations().forEach(Integration::onEnable);
    }

    @Override
    public <T extends Integration> void register(IntegrationType<? extends T> type, T integration) {
        if (!integration.isEnabled()) {
            return;
        }
        Logger.log("Registering integration " + integration.getId() + " with type " + type.name());
        this.integrationRegistry.register(type, integration);
    }

    public void clear() {
        this.integrationRegistry.clear();
    }

    public <T extends Integration> Set<T> retrieve(IntegrationType<T> type) {
        Set<T> integrations = this.integrationRegistry.getIntegrations(type);
        if (integrations.isEmpty()) {
            return Set.of();
        }
        return integrations;
    }

    @Generated
    public IntegrationRegistry getIntegrationRegistry() {
        return this.integrationRegistry;
    }
}

