/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.configuration.serializer;

import dev.jsinco.brewery.lib.eu.okaeri.configs.schema.GenericsDeclaration;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.DeserializationData;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.ObjectSerializer;
import dev.jsinco.brewery.lib.eu.okaeri.configs.serdes.SerializationData;
import java.awt.Color;
import java.util.HexFormat;
import lombok.NonNull;
import net.kyori.adventure.text.format.NamedTextColor;

public class ColorSerializer
implements ObjectSerializer<Color> {
    private static final HexFormat EXPLICIT_HEX_FORMAT = HexFormat.of().withPrefix("#");
    private static final HexFormat IMPLICIT_HEX_FORMAT = HexFormat.of();

    @Override
    public boolean supports(@NonNull Class<? super Color> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        return Color.class.isAssignableFrom(type);
    }

    @Override
    public void serialize(@NonNull Color object, @NonNull SerializationData data, @NonNull GenericsDeclaration generics) {
        if (object == null) {
            throw new NullPointerException("object is marked non-null but is null");
        }
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        int rgb = object.getRGB() & 0xFFFFFF;
        for (NamedTextColor textColor : NamedTextColor.NAMES.values()) {
            if ((textColor.value() & 0xFFFFFF) != rgb) continue;
            data.setValue(textColor.toString());
            return;
        }
        data.setValue(EXPLICIT_HEX_FORMAT.toHexDigits(rgb, 6));
    }

    @Override
    public Color deserialize(@NonNull DeserializationData data, @NonNull GenericsDeclaration generics) {
        if (data == null) {
            throw new NullPointerException("data is marked non-null but is null");
        }
        if (generics == null) {
            throw new NullPointerException("generics is marked non-null but is null");
        }
        String serializedColor = data.getValue(String.class);
        if (serializedColor == null) {
            return null;
        }
        if (serializedColor.startsWith("#")) {
            return new Color(HexFormat.fromHexDigits(serializedColor, 1, 7));
        }
        for (NamedTextColor textColor : NamedTextColor.NAMES.values()) {
            if (!textColor.toString().equalsIgnoreCase(serializedColor)) continue;
            return new Color(textColor.value());
        }
        return new Color(HexFormat.fromHexDigits(serializedColor));
    }
}

