/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command.argument;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.jsinco.brewery.api.event.CustomEvent;
import dev.jsinco.brewery.api.event.DrunkEvent;
import dev.jsinco.brewery.api.event.EventData;
import dev.jsinco.brewery.api.event.NamedDrunkEvent;
import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.integration.IntegrationTypes;
import dev.jsinco.brewery.bukkit.command.argument.ArgumentUtil;
import dev.jsinco.brewery.bukkit.util.BukkitMessageUtil;
import dev.jsinco.brewery.bukkit.util.EventUtil;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.minimessage.tag.resolver.Placeholder;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.jetbrains.annotations.NotNull;
import org.jspecify.annotations.NonNull;

public class EventArgument
implements CustomArgumentType.Converted<DrunkEvent, String> {
    private static final DynamicCommandExceptionType ERROR_INVALID_EVENT = new DynamicCommandExceptionType(event -> BukkitMessageUtil.toBrigadier("tbp.command.illegal-argument-detailed", new TagResolver[]{Placeholder.unparsed((String)"arguments", (String)event.toString())}));

    public DrunkEvent convert(String nativeType) throws CommandSyntaxException {
        BreweryKey key = BreweryKey.parse(nativeType);
        NamedDrunkEvent namedDrunkEvent = BreweryRegistry.DRUNK_EVENT.get(key);
        if (namedDrunkEvent != null) {
            return namedDrunkEvent;
        }
        CustomEvent.Keyed customEvent = TheBrewingProject.getInstance().getCustomDrunkEventRegistry().getCustomEvent(key);
        if (customEvent != null) {
            return customEvent;
        }
        EventData eventData = EventData.deserialize(nativeType);
        return (DrunkEvent)TheBrewingProject.getInstance().getIntegrationManager().getIntegrationRegistry().getIntegrations(IntegrationTypes.EVENT).stream().map(eventIntegration -> eventIntegration.convertToEvent(eventData)).flatMap(Optional::stream).findFirst().orElseThrow(() -> ERROR_INVALID_EVENT.create((Object)nativeType));
    }

    public <S> @NonNull CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, SuggestionsBuilder builder) {
        List<BreweryKey> all = EventUtil.listAll();
        String remaining = ArgumentUtil.escapeQuotes(builder.getRemainingLowerCase());
        all.stream().map(BreweryKey::minimalized).filter(event -> event.startsWith(remaining)).map(ArgumentUtil::sanitizeName).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }
}

