/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.util.MessageUtil;
import io.papermc.paper.command.brigadier.CommandSourceStack;
import io.papermc.paper.command.brigadier.Commands;
import java.util.Base64;
import java.util.List;
import javax.crypto.SecretKey;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.command.CommandSender;

public class EncryptionCommand {
    public static LiteralArgumentBuilder<CommandSourceStack> command() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rotate_key").executes(context -> {
            EncryptionCommand.rotateKey(((CommandSourceStack)context.getSource()).getSender(), null);
            return 1;
        })).then(Commands.argument((String)"reencrypt", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            boolean reencrypt = BoolArgumentType.getBool((CommandContext)context, (String)"reencrypt");
            EncryptionCommand.rotateKey(((CommandSourceStack)context.getSource()).getSender(), reencrypt);
            return 1;
        }));
    }

    private static void rotateKey(CommandSender sender, Boolean reencrypt) {
        if (reencrypt != null) {
            Config.config().set("reencryptItemsInInventories", reencrypt);
        }
        List<SecretKey> previousKeys = Config.config().previousEncryptionKeys();
        previousKeys.add(Config.config().encryptionKey());
        Config.config().set("previousEncryptionKeys", previousKeys.stream().map(key -> Base64.getEncoder().encodeToString(key.getEncoded())).toList());
        Config.config().set("encryptionKey", Base64.getEncoder().encodeToString(Config.generateAesKey().getEncoded()));
        Config.config().save();
        MessageUtil.message((Audience)sender, "tbp.command.encryption.rotate_key", new TagResolver[0]);
    }
}

