/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries.barrel;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.breweries.Barrel;
import dev.jsinco.brewery.api.breweries.BarrelAccess;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.breweries.BrewInventory;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.api.util.CancelState;
import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.api.util.HolderProviderHolder;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.brew.AgeStepImpl;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.api.event.process.BrewAgeEvent;
import dev.jsinco.brewery.bukkit.brew.BrewAdapter;
import dev.jsinco.brewery.bukkit.breweries.BrewInventoryImpl;
import dev.jsinco.brewery.bukkit.breweries.barrel.BarrelBrewPersistenceHandler;
import dev.jsinco.brewery.bukkit.structure.PlacedBreweryStructure;
import dev.jsinco.brewery.bukkit.util.LocationUtil;
import dev.jsinco.brewery.bukkit.util.SoundPlayer;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.util.MessageUtil;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import lombok.Generated;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

public class BukkitBarrel
implements Barrel<BukkitBarrel, ItemStack, Inventory>,
BarrelAccess {
    private final PlacedBreweryStructure<BukkitBarrel> structure;
    private final int size;
    private final BarrelType type;
    private final Location uniqueLocation;
    private final BrewInventoryImpl inventory;
    private long recentlyAccessed = -1L;
    private long ticksUntilNextCheck = 0L;
    private static final Random RANDOM = new Random();

    public BukkitBarrel(Location uniqueLocation, @NotNull PlacedBreweryStructure<BukkitBarrel> structure, int size, @NotNull BarrelType type) {
        this.structure = (PlacedBreweryStructure)Preconditions.checkNotNull(structure);
        this.size = size;
        this.type = (BarrelType)Preconditions.checkNotNull((Object)type);
        this.uniqueLocation = (Location)Preconditions.checkNotNull((Object)uniqueLocation);
        this.inventory = new BrewInventoryImpl((Component)Component.translatable((String)"tbp.barrel.gui-title"), size, new BarrelBrewPersistenceHandler(BukkitAdapter.toBreweryLocation(uniqueLocation)));
    }

    @Override
    public CancelState open(@NotNull BreweryLocation location, @NotNull Holder.Player playerHolder) {
        Player player = BukkitAdapter.toPlayer(playerHolder).orElse(null);
        if (player == null) {
            return new CancelState.Cancelled();
        }
        if (!player.hasPermission("brewery.barrel.access")) {
            return new CancelState.PermissionDenied((Component)Component.translatable((String)"tbp.barrel.access-denied"));
        }
        if (this.inventoryUnpopulated()) {
            this.inventory.updateInventoryFromBrews();
        }
        this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        if (this.uniqueLocation != null) {
            SoundPlayer.playSoundEffect(Config.config().sounds().barrelOpen(), Sound.Source.BLOCK, this.uniqueLocation.toCenterLocation());
        }
        player.openInventory(this.inventory.getInventory());
        return new CancelState.Allowed();
    }

    @Override
    public boolean inventoryAllows(@NotNull UUID playerUuid, @NotNull ItemStack item) {
        Player player = Bukkit.getPlayer((UUID)playerUuid);
        if (player == null) {
            return false;
        }
        if (!player.hasPermission("brewery.barrel.access")) {
            MessageUtil.message((Audience)player, "tbp.barrel.access-denied", new TagResolver[0]);
            return false;
        }
        return this.inventoryAllows(item);
    }

    @Override
    public boolean inventoryAllows(@NotNull ItemStack item) {
        return BrewAdapter.fromItem(item).isPresent();
    }

    @Override
    public Set<Inventory> getInventories() {
        return Set.of(this.inventory.getInventory());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean open(@NotNull BreweryLocation breweryLocation, @NotNull UUID playerUuid) {
        CancelState cancelState;
        Optional<Holder.Player> playerOptional = HolderProviderHolder.instance().player(playerUuid);
        CancelState cancelState2 = cancelState = playerOptional.map(player -> this.open(breweryLocation, (Holder.Player)player)).orElseGet(CancelState.Cancelled::new);
        Objects.requireNonNull(cancelState2);
        CancelState cancelState3 = cancelState2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{CancelState.Cancelled.class, CancelState.Allowed.class, CancelState.PermissionDenied.class}, (Object)cancelState3, n)) {
            default: {
                throw new MatchException(null, null);
            }
            case 0: {
                CancelState.Cancelled ignored = (CancelState.Cancelled)cancelState3;
                return false;
            }
            case 1: {
                CancelState.Allowed ignored = (CancelState.Allowed)cancelState3;
                return true;
            }
            case 2: 
        }
        CancelState.PermissionDenied permissionDenied = (CancelState.PermissionDenied)cancelState3;
        try {
            Component component;
            Component message = component = permissionDenied.message();
            playerOptional.flatMap(BukkitAdapter::toPlayer).ifPresent(player -> player.sendMessage(message));
            return false;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
    }

    @Override
    public void close(boolean silent) {
        this.ticksUntilNextCheck = 0L;
        Brew[] previousBrews = Arrays.copyOf(this.inventory.getBrews(), this.inventory.getBrews().length);
        this.inventory.updateBrewsFromInventory();
        this.processBrews(previousBrews);
        if (!silent && this.uniqueLocation != null) {
            SoundPlayer.playSoundEffect(Config.config().sounds().barrelClose(), Sound.Source.BLOCK, this.uniqueLocation.toCenterLocation());
        }
        this.inventory.getInventory().clear();
    }

    @Override
    public void tickInventory() {
        if (this.shouldUnpopulateInventory()) {
            this.close(false);
            TheBrewingProject.getInstance().getBreweryRegistry().unregisterOpened(this);
            this.recentlyAccessed = -1L;
            return;
        }
        if (!this.inventory.getInventory().getViewers().isEmpty()) {
            this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        }
        if (this.ticksUntilNextCheck-- > 0L) {
            return;
        }
        this.ticksUntilNextCheck = Math.min(Config.config().barrels().agingYearTicks() / 20L, 6000L);
        Brew[] previousBrews = Arrays.copyOf(this.inventory.getBrews(), this.inventory.getBrews().length);
        this.inventory.updateBrewsFromInventory();
        this.processBrews(previousBrews);
        this.inventory.updateInventoryFromBrews();
        this.getInventory().getInventory().getViewers().stream().filter(Player.class::isInstance).map(Player.class::cast).forEach(Player::updateInventory);
    }

    private void processBrews(Brew[] previousBrews) {
        Brew[] brews = this.inventory.getBrews();
        long time = TheBrewingProject.getInstance().getTime();
        for (int i = 0; i < brews.length; ++i) {
            Brew aged;
            BrewingStep.Age age;
            Brew brew = brews[i];
            if (brew == null) continue;
            int idx = i;
            BrewingStep brewingStep = brew.lastStep();
            if (!(brewingStep instanceof BrewingStep.Age) || (age = (BrewingStep.Age)brewingStep).barrelType() != this.type) {
                aged = brew.withStep(new AgeStepImpl(new Interval(time, time), this.type));
                this.callAgeEvent(brew, aged).ifPresent(result -> this.inventory.store((Brew)result, idx));
                continue;
            }
            aged = Objects.equals(previousBrews[i], brew) ? brew.withLastStep(BrewingStep.Age.class, age1 -> age1.withAge(age.time().withLastStep(time)), () -> new AgeStepImpl(new Interval(time, time), this.type)) : brew.withLastStep(BrewingStep.Age.class, age1 -> age1.withAge(age.time().withMovedEnding(time)), () -> new AgeStepImpl(new Interval(time, time), this.type));
            this.callAgeEvent(brew, aged).ifPresent(result -> {
                brews[idx] = result;
            });
        }
    }

    private Optional<Brew> callAgeEvent(Brew source, Brew result) {
        BrewAgeEvent event = new BrewAgeEvent(this, source, result);
        if (!event.callEvent()) {
            return Optional.empty();
        }
        return Optional.of(event.getResult());
    }

    @Override
    public Optional<Inventory> access(@NotNull BreweryLocation breweryLocation) {
        if (this.inventoryUnpopulated()) {
            this.inventory.updateInventoryFromBrews();
            TheBrewingProject.getInstance().getBreweryRegistry().registerOpened(this);
        }
        this.recentlyAccessed = TheBrewingProject.getInstance().getTime();
        return Optional.of(this.inventory.getInventory());
    }

    @Override
    public Brew initializeBrew(Brew brew) {
        BrewingStep.Age age;
        long time = TheBrewingProject.getInstance().getTime();
        BrewingStep brewingStep = brew.lastStep();
        if (!(brewingStep instanceof BrewingStep.Age) || (age = (BrewingStep.Age)brewingStep).barrelType() != this.type) {
            return brew.withStep(new AgeStepImpl(new Interval(time, time), this.type));
        }
        return brew;
    }

    public List<Brew> calculateDestroyDrops() {
        if (!this.inventoryUnpopulated()) {
            this.inventory.updateBrewsFromInventory();
        }
        return this.inventory.getBrewSnapshot();
    }

    public void destroyWithoutDrops() {
        this.inventory.destroy();
    }

    @Override
    public void destroy(BreweryLocation breweryLocation) {
        this.calculateDestroyDrops();
        LocationUtil.dropBrews(breweryLocation, this.inventory.destroy());
    }

    @Override
    public BrewInventory getBrewInventory() {
        return this.inventory;
    }

    @Override
    public PlacedBreweryStructure<BukkitBarrel> getStructure() {
        return this.structure;
    }

    World getWorld() {
        return this.uniqueLocation.getWorld();
    }

    public List<Pair<Brew, Integer>> getBrews() {
        ArrayList<Pair<Brew, Integer>> brewList = new ArrayList<Pair<Brew, Integer>>();
        for (int i = 0; i < this.inventory.getBrews().length; ++i) {
            if (this.inventory.getBrews()[i] == null) continue;
            brewList.add(new Pair<Brew, Integer>(this.inventory.getBrews()[i], i));
        }
        return brewList;
    }

    private boolean inventoryUnpopulated() {
        return this.recentlyAccessed == -1L;
    }

    private boolean shouldUnpopulateInventory() {
        return this.recentlyAccessed == -1L || this.recentlyAccessed + 20L <= TheBrewingProject.getInstance().getTime();
    }

    @Generated
    public BrewInventoryImpl getInventory() {
        return this.inventory;
    }

    @Generated
    public long getRecentlyAccessed() {
        return this.recentlyAccessed;
    }

    @Generated
    public long getTicksUntilNextCheck() {
        return this.ticksUntilNextCheck;
    }

    @Generated
    public int getSize() {
        return this.size;
    }

    @Generated
    public BarrelType getType() {
        return this.type;
    }

    @Generated
    public Location getUniqueLocation() {
        return this.uniqueLocation;
    }
}

