/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.breweries;

import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.brew.BrewQuality;
import dev.jsinco.brewery.api.brew.BrewScore;
import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.breweries.Cauldron;
import dev.jsinco.brewery.api.breweries.CauldronType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.moment.Interval;
import dev.jsinco.brewery.api.recipe.Recipe;
import dev.jsinco.brewery.api.util.BreweryRegistry;
import dev.jsinco.brewery.api.util.CancelState;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import dev.jsinco.brewery.brew.BrewImpl;
import dev.jsinco.brewery.brew.CookStepImpl;
import dev.jsinco.brewery.brew.MixStepImpl;
import dev.jsinco.brewery.bukkit.TheBrewingProject;
import dev.jsinco.brewery.bukkit.api.BukkitAdapter;
import dev.jsinco.brewery.bukkit.api.event.process.BrewCauldronProcessEvent;
import dev.jsinco.brewery.bukkit.api.event.transaction.CauldronInsertEvent;
import dev.jsinco.brewery.bukkit.api.transaction.ItemSource;
import dev.jsinco.brewery.bukkit.ingredient.BukkitIngredientManager;
import dev.jsinco.brewery.bukkit.listener.ListenerUtil;
import dev.jsinco.brewery.bukkit.recipe.BukkitRecipeResult;
import dev.jsinco.brewery.bukkit.util.BlockUtil;
import dev.jsinco.brewery.bukkit.util.BukkitIngredientUtil;
import dev.jsinco.brewery.bukkit.util.ColorUtil;
import dev.jsinco.brewery.bukkit.util.SoundPlayer;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.sound.SoundDefinition;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import lombok.Generated;
import net.kyori.adventure.sound.Sound;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Particle;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.BlockType;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitCauldron
implements Cauldron {
    private static final Random RANDOM = new Random();
    private final BreweryLocation location;
    private boolean hot = false;
    private Brew brew;
    private boolean brewExtracted = false;
    private org.bukkit.Color particleColor = org.bukkit.Color.AQUA;
    @Nullable
    private Recipe<ItemStack> recipe;
    private boolean dirty = true;

    public BukkitCauldron(BreweryLocation location, boolean hot) {
        this.location = location;
        this.hot = hot;
        this.brew = new BrewImpl(List.of());
    }

    public BukkitCauldron(Brew brew, BreweryLocation location) {
        this.location = location;
        this.brew = brew;
    }

    private static Optional<CauldronType> findCauldronType(Block block) {
        return BreweryRegistry.CAULDRON_TYPE.values().stream().filter(cauldronType -> block.getType().getKey().toString().equals(cauldronType.materialKey())).findAny();
    }

    @Override
    public void tick() {
        if (!BlockUtil.isChunkLoaded(this.location)) {
            return;
        }
        if (!Tag.CAULDRONS.isTagged((Keyed)this.getBlock().getType()) || this.getBlock().getType() == Material.CAULDRON) {
            ListenerUtil.removeActiveSinglePositionStructure(this, TheBrewingProject.getInstance().getBreweryRegistry(), TheBrewingProject.getInstance().getDatabase());
            return;
        }
        this.hot = BukkitCauldron.isHeatSource(this.getBlock().getRelative(BlockFace.DOWN));
        this.recalculateBrewTime();
        if (this.dirty || this.getBrewTime() % Config.config().cauldrons().cookingMinuteTicks() == 0L) {
            this.recipe = this.brew.closestRecipe(TheBrewingProject.getInstance().getRecipeRegistry()).orElse(null);
            this.dirty = false;
        }
        Optional<Recipe<ItemStack>> recipeOptional = Optional.ofNullable(this.recipe);
        org.bukkit.Color resultColor = this.computeResultColor(recipeOptional);
        org.bukkit.Color baseParticleColor = this.computeBaseParticleColor(this.getBlock());
        this.particleColor = recipeOptional.map(recipe -> this.computeParticleColor(baseParticleColor, resultColor, (Recipe<ItemStack>)recipe)).orElseGet(() -> ColorUtil.getNextColor(baseParticleColor, this.convert(Config.config().cauldrons().failedParticleColor()), this.getBrewTime(), 3600L));
        this.playBrewingEffects();
    }

    private long getBrewTime() {
        BrewingStep brewingStep = this.brew.lastStep();
        if (brewingStep instanceof BrewingStep.TimedStep) {
            BrewingStep.TimedStep timedStep = (BrewingStep.TimedStep)brewingStep;
            return timedStep.time().moment();
        }
        return 0L;
    }

    private org.bukkit.Color computeParticleColor(org.bukkit.Color baseColor, org.bukkit.Color resultColor, Recipe<ItemStack> recipe) {
        BrewingStep expectedCook;
        BrewingStep brewingStep = this.brew.lastStep();
        if (brewingStep instanceof BrewingStep.Cook) {
            BrewingStep.Cook cook = (BrewingStep.Cook)brewingStep;
            expectedCook = (BrewingStep.Cook)recipe.getSteps().get(this.brew.getCompletedSteps().size() - 1);
            return ColorUtil.getNextColor(baseColor, resultColor, cook.time().moment(), expectedCook.time().moment());
        }
        expectedCook = this.brew.lastStep();
        if (expectedCook instanceof BrewingStep.Mix) {
            BrewingStep.Mix mix = (BrewingStep.Mix)expectedCook;
            BrewingStep.Mix expectedMix = (BrewingStep.Mix)recipe.getSteps().get(this.brew.getCompletedSteps().size() - 1);
            return ColorUtil.getNextColor(baseColor, resultColor, mix.time().moment(), expectedMix.time().moment());
        }
        return baseColor;
    }

    private org.bukkit.Color computeResultColor(Optional<Recipe<ItemStack>> recipeOptional) {
        Map<? extends Ingredient, Integer> ingredients;
        if (recipeOptional.isEmpty()) {
            return this.convert(Config.config().cauldrons().failedParticleColor());
        }
        BrewingStep brewingStep = this.brew.lastStep();
        if (brewingStep instanceof BrewingStep.Cook) {
            BrewingStep.Cook cook = (BrewingStep.Cook)brewingStep;
            ingredients = cook.ingredients();
        } else {
            brewingStep = this.brew.lastStep();
            if (brewingStep instanceof BrewingStep.Mix) {
                BrewingStep.Mix mix = (BrewingStep.Mix)brewingStep;
                ingredients = mix.ingredients();
            } else {
                return org.bukkit.Color.AQUA;
            }
        }
        BrewScore score = this.brew.score(recipeOptional.get());
        BrewQuality brewQuality = score.brewQuality();
        if (brewQuality == null) {
            return this.convert(Config.config().cauldrons().failedParticleColor());
        }
        return !score.completed() ? BukkitIngredientUtil.ingredientData(ingredients).first() : ((BukkitRecipeResult)recipeOptional.get().getRecipeResults().get(brewQuality)).getColor();
    }

    public void remove() {
        ListenerUtil.removeActiveSinglePositionStructure(this, TheBrewingProject.getInstance().getBreweryRegistry(), TheBrewingProject.getInstance().getDatabase());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addIngredient(@NotNull ItemStack item, Player player) {
        CauldronInsertEvent insertEvent = new CauldronInsertEvent(this, new ItemSource.ItemBasedSource(item), (CancelState)((Object)(player.hasPermission("brewery.cauldron.access") ? new CancelState.Allowed() : new CancelState.PermissionDenied((Component)Component.translatable((String)"tbp.cauldron.access-denied")))), player);
        if (!insertEvent.callEvent()) {
            CancelState cancelState = insertEvent.getCancelState();
            if (cancelState instanceof CancelState.PermissionDenied) {
                Component denyMessage;
                CancelState.PermissionDenied permissionDenied = (CancelState.PermissionDenied)cancelState;
                try {
                    Component component;
                    denyMessage = component = permissionDenied.message();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                player.sendMessage(denyMessage);
            }
            return false;
        }
        ItemStack addedItem = insertEvent.getItemSource().get();
        if (!this.brewExtracted && addedItem.getType() == Material.POTION) {
            BukkitCauldron.incrementLevel(this.getBlock());
        }
        this.hot = BukkitCauldron.isHeatSource(this.getBlock().getRelative(BlockFace.DOWN));
        CauldronType cauldronType = this.getType().orElseThrow(() -> new IllegalStateException("Expected cauldron block type for cauldron"));
        long time = TheBrewingProject.getInstance().getTime();
        Ingredient ingredient = BukkitIngredientManager.INSTANCE.getIngredient(addedItem);
        Brew mixed = this.hot ? this.brew.withLastStep(BrewingStep.Cook.class, cook -> {
            HashMap<? extends Ingredient, Integer> ingredients = new HashMap<Ingredient, Integer>(cook.ingredients());
            int amount = ingredients.computeIfAbsent(ingredient, ignored -> 0);
            ingredients.put(ingredient, amount + 1);
            return cook.withIngredients(ingredients);
        }, () -> new CookStepImpl(new Interval(time, time), Map.of(BukkitIngredientManager.INSTANCE.getIngredient(addedItem), 1), cauldronType)) : this.brew.withLastStep(BrewingStep.Mix.class, mix -> {
            HashMap<? extends Ingredient, Integer> ingredients = new HashMap<Ingredient, Integer>(mix.ingredients());
            int amount = ingredients.computeIfAbsent(ingredient, ignored -> 0);
            ingredients.put(ingredient, amount + 1);
            return mix.withIngredients(ingredients);
        }, () -> new MixStepImpl(new Interval(time, time), Map.of(BukkitIngredientManager.INSTANCE.getIngredient(addedItem), 1)));
        BrewCauldronProcessEvent mixEvent = new BrewCauldronProcessEvent(this, cauldronType, this.hot, this.brew, mixed);
        if (!mixEvent.callEvent()) {
            return true;
        }
        this.brew = mixEvent.getResult().witModifiedLastStep(step -> {
            BrewingStep brewingStep;
            if (step instanceof BrewingStep.AuthoredStep) {
                BrewingStep.AuthoredStep authoredStep = (BrewingStep.AuthoredStep)step;
                brewingStep = authoredStep.withBrewer(player.getUniqueId());
            } else {
                brewingStep = step;
            }
            return brewingStep;
        });
        this.recipe = this.brew.closestRecipe(TheBrewingProject.getInstance().getRecipeRegistry()).orElse(null);
        this.playIngredientAddedEffects(addedItem);
        return true;
    }

    private org.bukkit.Color computeBaseParticleColor(Block block) {
        return switch (block.getType()) {
            case Material.WATER_CAULDRON -> this.convert(Config.config().cauldrons().waterBaseParticleColor());
            case Material.LAVA_CAULDRON -> this.convert(Config.config().cauldrons().lavaBaseParticleColor());
            case Material.POWDER_SNOW_CAULDRON -> this.convert(Config.config().cauldrons().snowBaseParticleColor());
            default -> throw new IllegalStateException("Expected block to be cauldron type");
        };
    }

    public void playBrewingEffects() {
        Block block = this.getBlock();
        Location particleLoc = block.getLocation().add(0.5 + (RANDOM.nextDouble() * 0.8 - 0.4), 0.9, 0.5 + (RANDOM.nextDouble() * 0.8 - 0.4));
        block.getWorld().spawnParticle(Particle.ENTITY_EFFECT, particleLoc, 0, (Object)this.particleColor);
        if (!Config.config().cauldrons().minimalParticles() || !this.hot) {
            return;
        }
        if ((double)RANDOM.nextFloat() > 0.85) {
            block.getWorld().spawnParticle(Particle.LARGE_SMOKE, particleLoc, 0, 0.0, 1.0, 0.0, 0.09);
        }
        if ((double)RANDOM.nextFloat() > 0.2) {
            block.getWorld().spawnParticle(Particle.SPLASH, particleLoc, 1, 0.2, 0.0, 0.2);
        }
        if ((double)RANDOM.nextFloat() > 0.4) {
            block.getWorld().spawnParticle(Particle.DUST_PLUME, particleLoc, 2, 0.15, 0.2, 0.15, (Object)new Particle.DustOptions(this.particleColor, 1.5f));
        }
    }

    public void playIngredientAddedEffects(ItemStack item) {
        BukkitAdapter.toLocation(this.location).map(Location::toCenterLocation).filter(Location::isChunkLoaded).ifPresent(bukkitLocation -> {
            World world = bukkitLocation.getWorld();
            SoundDefinition sound = item.getType() == Material.POTION ? Config.config().sounds().cauldronIngredientAddBrew() : Config.config().sounds().cauldronIngredientAdd();
            SoundPlayer.playSoundEffect(sound, Sound.Source.BLOCK, bukkitLocation);
            if (bukkitLocation.getBlock().getType() == Material.WATER_CAULDRON) {
                world.spawnParticle(Particle.SPLASH, bukkitLocation.add(0.0, 0.5, 0.0), 50, 0.1, 0.05, 0.1, 1.0);
            }
        });
    }

    public void playBrewExtractedEffects() {
        BukkitAdapter.toWorld(this.location).ifPresent(world -> SoundPlayer.playSoundEffect(Config.config().sounds().cauldronBrewExtract(), Sound.Source.BLOCK, world, (double)this.location.x() + 0.5, this.location.y() + 1, (double)this.location.z() + 0.5));
    }

    public static boolean isHeatSource(Block block) {
        if (Config.config().cauldrons().heatSources().isEmpty()) {
            return true;
        }
        Material material = block.getType();
        if (!Config.config().cauldrons().heatSources().contains(BukkitAdapter.toMaterialHolder(material))) {
            return false;
        }
        if (material == Material.CAMPFIRE || material == Material.SOUL_CAMPFIRE) {
            return BlockUtil.isLitCampfire(block);
        }
        if (material == Material.LAVA) {
            return BlockUtil.isSource(block);
        }
        return true;
    }

    @Override
    public BreweryLocation position() {
        return this.location;
    }

    public Brew getUpdatedBrew() {
        this.recalculateBrewTime();
        return this.brew;
    }

    public void extractBrew() {
        this.brewExtracted = true;
        this.playBrewExtractedEffects();
    }

    private void recalculateBrewTime() {
        long time = TheBrewingProject.getInstance().getTime();
        this.brew = this.hot ? this.brew.withLastStep(BrewingStep.Cook.class, cook -> cook.withBrewTime(cook.time().withLastStep(time)), () -> new CookStepImpl(new Interval(time, time), Map.of(), this.getType().orElseThrow(() -> new IllegalStateException("Expected cauldron block type for cauldron")))) : this.brew.withLastStep(BrewingStep.Mix.class, mix -> mix.withTime(mix.time().withLastStep(time)), () -> new MixStepImpl(new Interval(time, time), Map.of()));
    }

    private Block getBlock() {
        return BukkitAdapter.toBlock(this.location).orElseThrow(() -> new IllegalStateException("Could not find world for cauldron"));
    }

    public static void incrementLevel(Block block) {
        BlockData blockData = block.getBlockData();
        if (blockData instanceof Levelled) {
            Levelled levelled = (Levelled)blockData;
            levelled.setLevel(Math.min(levelled.getLevel() + 1, levelled.getMaximumLevel()));
            block.setBlockData((BlockData)levelled);
        } else {
            Levelled waterCauldron = (Levelled)BlockType.WATER_CAULDRON.createBlockData();
            waterCauldron.setLevel(1);
            block.setBlockData((BlockData)waterCauldron);
        }
    }

    public static boolean decrementLevel(Block block) {
        if (!Tag.CAULDRONS.isTagged((Keyed)block.getType())) {
            return true;
        }
        BlockData blockData = block.getBlockData();
        if (!(blockData instanceof Levelled)) {
            block.setType(Material.CAULDRON);
            return true;
        }
        Levelled levelled = (Levelled)blockData;
        if (levelled.getLevel() == 1) {
            block.setType(Material.CAULDRON);
            return true;
        }
        levelled.setLevel(levelled.getLevel() - 1);
        block.setBlockData((BlockData)levelled);
        return false;
    }

    @Override
    public long getTime() {
        if (this.brew.getCompletedSteps().isEmpty()) {
            return 0L;
        }
        BrewingStep brewingStep = this.brew.lastStep();
        if (brewingStep instanceof BrewingStep.Cook) {
            BrewingStep.Cook cook = (BrewingStep.Cook)brewingStep;
            return cook.time().moment();
        }
        brewingStep = this.brew.lastStep();
        if (brewingStep instanceof BrewingStep.Mix) {
            BrewingStep.Mix mix = (BrewingStep.Mix)brewingStep;
            return mix.time().moment();
        }
        return 0L;
    }

    @Override
    @NotNull
    public Optional<CauldronType> getType() {
        return BukkitCauldron.findCauldronType(this.getBlock());
    }

    @Override
    public int getLevel() {
        if (this.getBlock().getType() == Material.LAVA_CAULDRON) {
            return 1;
        }
        BlockData blockData = this.getBlock().getBlockData();
        if (blockData instanceof Levelled) {
            Levelled levelled = (Levelled)blockData;
            return levelled.getLevel();
        }
        return 0;
    }

    private org.bukkit.Color convert(Color awtColor) {
        return org.bukkit.Color.fromRGB((int)(awtColor.getRGB() & 0xFFFFFF));
    }

    @Override
    @Generated
    public boolean isHot() {
        return this.hot;
    }

    @Generated
    public void setHot(boolean hot) {
        this.hot = hot;
    }

    @Override
    @Generated
    public Brew getBrew() {
        return this.brew;
    }
}

