/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.api.event.transaction;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.brew.Brew;
import dev.jsinco.brewery.api.breweries.Cauldron;
import dev.jsinco.brewery.api.util.CancelState;
import dev.jsinco.brewery.bukkit.api.event.PermissibleBreweryEvent;
import dev.jsinco.brewery.bukkit.api.transaction.ItemSource;
import lombok.Generated;
import org.bukkit.entity.Player;
import org.bukkit.event.HandlerList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CauldronExtractEvent
extends PermissibleBreweryEvent {
    private final Cauldron cauldron;
    private ItemSource.BrewBasedSource brewSource;
    @Nullable
    private final Player player;
    private static final HandlerList HANDLERS = new HandlerList();

    public CauldronExtractEvent(Cauldron cauldron, ItemSource.BrewBasedSource brewSource, @NotNull CancelState state, @Nullable Player player) {
        super(state);
        this.cauldron = cauldron;
        this.brewSource = brewSource;
        this.player = player;
    }

    public void setResult(@NotNull Brew brew) {
        Preconditions.checkNotNull((Object)brew);
        this.brewSource = new ItemSource.BrewBasedSource(brew, new Brew.State.Other());
    }

    @NotNull
    public HandlerList getHandlers() {
        return HANDLERS;
    }

    public static HandlerList getHandlerList() {
        return HANDLERS;
    }

    @Generated
    public Cauldron getCauldron() {
        return this.cauldron;
    }

    @Generated
    public ItemSource.BrewBasedSource getBrewSource() {
        return this.brewSource;
    }

    @Nullable
    @Generated
    public Player getPlayer() {
        return this.player;
    }
}

