/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.bukkit.api;

import dev.jsinco.brewery.api.util.BreweryKey;
import dev.jsinco.brewery.api.util.Holder;
import dev.jsinco.brewery.api.vector.BreweryLocation;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BukkitAdapter {
    public static Optional<Location> toLocation(BreweryLocation location) {
        return Optional.ofNullable(Bukkit.getWorld((UUID)location.worldUuid())).map(world -> new Location(world, (double)location.x(), (double)location.y(), (double)location.z()));
    }

    public static BreweryLocation toBreweryLocation(Location location) {
        return new BreweryLocation(location.getBlockX(), location.getBlockY(), location.getBlockZ(), location.getWorld().getUID());
    }

    public static BreweryLocation toBreweryLocation(Block block) {
        return new BreweryLocation(block.getX(), block.getY(), block.getZ(), block.getWorld().getUID());
    }

    public static Optional<Block> toBlock(BreweryLocation location) {
        return Optional.ofNullable(Bukkit.getWorld((UUID)location.worldUuid())).map(world -> world.getBlockAt(location.x(), location.y(), location.z()));
    }

    public static NamespacedKey toNamespacedKey(BreweryKey breweryKey) {
        return NamespacedKey.fromString((String)breweryKey.toString());
    }

    public static BreweryKey toBreweryKey(NamespacedKey namespacedKey) {
        return new BreweryKey(namespacedKey.namespace(), namespacedKey.getKey());
    }

    public static Optional<World> toWorld(BreweryLocation location) {
        return Optional.ofNullable(Bukkit.getWorld((UUID)location.worldUuid()));
    }

    @Nullable
    public static Material toMaterial(Holder.Material material) {
        return (Material)Registry.MATERIAL.get(BukkitAdapter.toNamespacedKey(material.value()));
    }

    @NotNull
    public static Holder.Material toMaterialHolder(Material material) {
        return new Holder.Material(BukkitAdapter.toBreweryKey(material.getKey()));
    }

    public static Holder.Player toPlayerHolder(@NotNull Player player) {
        return new Holder.Player(player.getUniqueId());
    }

    public static Optional<Player> toPlayer(@NotNull Holder.Player player) {
        return Optional.ofNullable(Bukkit.getPlayer((UUID)player.value()));
    }

    public static Holder.World toWorldHolder(@NotNull World world) {
        return new Holder.World(world.getUID());
    }

    public static Optional<World> toWorldHolder(@NotNull Holder.World world) {
        return Optional.ofNullable(Bukkit.getWorld((UUID)world.value()));
    }
}

