/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import dev.jsinco.brewery.util.CollectionUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record MixStepImpl(Moment time, Map<? extends Ingredient, Integer> ingredients, SequencedSet<UUID> brewers) implements BrewingStep.Mix
{
    private static final Map<ScoreType, PartialBrewScore> BREW_STEP_MISMATCH = Stream.of(new PartialBrewScore(0.0, ScoreType.TIME), new PartialBrewScore(0.0, ScoreType.INGREDIENTS)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));

    public MixStepImpl(Moment time, Map<? extends Ingredient, Integer> ingredients) {
        this(time, ingredients, Collections.emptySortedSet());
    }

    @Override
    public MixStepImpl withIngredients(Map<? extends Ingredient, Integer> ingredients) {
        return new MixStepImpl(this.time, ingredients, this.brewers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<ScoreType, PartialBrewScore> proximityScores(BrewingStep other) {
        Moment otherTime;
        SequencedSet<UUID> sequencedSet;
        if (!(other instanceof MixStepImpl)) return BREW_STEP_MISMATCH;
        MixStepImpl mixStepImpl = (MixStepImpl)other;
        try {
            sequencedSet = mixStepImpl.time();
            otherTime = sequencedSet;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> otherIngredients = sequencedSet = mixStepImpl.ingredients();
        SequencedSet<UUID> ignored = sequencedSet = mixStepImpl.brewers();
        double timeScore = BrewingStepUtil.nearbyValueScore(this.time.moment(), otherTime.moment());
        double ingredientsScore = BrewingStepUtil.getIngredientsScore(this.ingredients, otherIngredients);
        return Stream.of(new PartialBrewScore(timeScore, ScoreType.TIME), new PartialBrewScore(ingredientsScore, ScoreType.INGREDIENTS)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.MIX;
    }

    @Override
    public Map<ScoreType, PartialBrewScore> maximumScores(BrewingStep other) {
        return this.proximityScores(other);
    }

    @Override
    public Map<ScoreType, PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }

    @Override
    public boolean isCompleted() {
        return true;
    }

    @Override
    public MixStepImpl withTime(Moment time) {
        return new MixStepImpl(time, this.ingredients, this.brewers);
    }

    @Override
    public BrewingStep.Mix withBrewersReplaced(SequencedCollection<UUID> brewers) {
        return new MixStepImpl(this.time, this.ingredients, new LinkedHashSet<UUID>(brewers));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Moment otherTime;
        SequencedSet<UUID> sequencedSet;
        if (!(o instanceof MixStepImpl)) return false;
        MixStepImpl mixStepImpl = (MixStepImpl)o;
        try {
            sequencedSet = mixStepImpl.time();
            otherTime = sequencedSet;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> otherIngredients = sequencedSet = mixStepImpl.ingredients();
        SequencedSet<UUID> otherBrewers = sequencedSet = mixStepImpl.brewers();
        if (!Objects.equals(this.time, otherTime)) return false;
        if (!Objects.equals(this.ingredients, otherIngredients)) return false;
        if (!CollectionUtil.isEqualWithOrdering(this.brewers, otherBrewers)) return false;
        return true;
    }
}

