/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import dev.jsinco.brewery.util.CollectionUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record DistillStepImpl(int runs, SequencedSet<UUID> brewers) implements BrewingStep.Distill
{
    private static final Map<ScoreType, PartialBrewScore> BREW_STEP_MISMATCH = Stream.of(new PartialBrewScore(0.0, ScoreType.DISTILL_AMOUNT)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));

    public DistillStepImpl(int runs) {
        this(runs, Collections.emptySortedSet());
    }

    @Override
    public DistillStepImpl incrementRuns() {
        return new DistillStepImpl(this.runs + 1, this.brewers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<ScoreType, PartialBrewScore> proximityScores(BrewingStep other) {
        SequencedSet<UUID> sequencedSet;
        int otherRuns;
        if (!(other instanceof DistillStepImpl)) return BREW_STEP_MISMATCH;
        DistillStepImpl distillStepImpl = (DistillStepImpl)other;
        try {
            int n;
            otherRuns = n = distillStepImpl.runs();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> ignored = sequencedSet = distillStepImpl.brewers();
        double distillScore = Math.sqrt(BrewingStepUtil.nearbyValueScore(this.runs, otherRuns));
        return Stream.of(new PartialBrewScore(distillScore, ScoreType.DISTILL_AMOUNT)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.DISTILL;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<ScoreType, PartialBrewScore> maximumScores(BrewingStep other) {
        SequencedSet<UUID> sequencedSet;
        int runs1;
        if (!(other instanceof DistillStepImpl)) return BREW_STEP_MISMATCH;
        DistillStepImpl distillStepImpl = (DistillStepImpl)other;
        try {
            int n;
            runs1 = n = distillStepImpl.runs();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> ignored = sequencedSet = distillStepImpl.brewers();
        double maximumDistillScore = runs1 < this.runs ? 1.0 : BrewingStepUtil.nearbyValueScore(this.runs, runs1);
        return Stream.of(new PartialBrewScore(maximumDistillScore, ScoreType.DISTILL_AMOUNT)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public Map<ScoreType, PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }

    @Override
    public boolean isCompleted() {
        return this.runs() > 0;
    }

    @Override
    public BrewingStep.Distill withBrewersReplaced(SequencedCollection<UUID> brewers) {
        return new DistillStepImpl(this.runs, new LinkedHashSet<UUID>(brewers));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        SequencedSet<UUID> sequencedSet;
        int otherRuns;
        if (!(o instanceof DistillStepImpl)) return false;
        DistillStepImpl distillStepImpl = (DistillStepImpl)o;
        try {
            int n;
            otherRuns = n = distillStepImpl.runs();
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> otherBrewers = sequencedSet = distillStepImpl.brewers();
        if (this.runs != otherRuns) return false;
        if (!CollectionUtil.isEqualWithOrdering(this.brewers, otherBrewers)) return false;
        return true;
    }
}

