/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.ingredient.BaseIngredient;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientGroup;
import dev.jsinco.brewery.api.ingredient.IngredientMeta;
import dev.jsinco.brewery.api.ingredient.IngredientWithMeta;
import dev.jsinco.brewery.api.util.Pair;
import dev.jsinco.brewery.util.IngredientUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.jspecify.annotations.Nullable;

public class BrewingStepUtil {
    public static double nearbyValueScore(long expected, long value) {
        double diff = Math.abs(expected - value);
        return 1.0 - Math.max(diff / (double)expected, 0.0);
    }

    public static double getIngredientsScore(Map<Ingredient, Integer> target, Map<Ingredient, Integer> actual) {
        Pair<Double, Integer> actualIngredientsScore = actual.entrySet().stream().flatMap(entry -> IngredientUtil.score((Ingredient)entry.getKey()).map(score -> new Pair<Double, Integer>(score * (double)((Integer)entry.getValue()).intValue(), (Integer)entry.getValue())).stream()).reduce(new Pair<Double, Integer>(0.0, 0), (pair1, pair2) -> new Pair<Double, Integer>((Double)pair1.first() + (Double)pair2.first(), (Integer)pair1.second() + (Integer)pair2.second()));
        Map<BaseIngredient, Integer> modifiedActual = IngredientUtil.sanitizeIngredients(actual);
        double ingredientScoreCumulativeSum = actualIngredientsScore.first();
        int scoredIngredientAmount = actualIngredientsScore.second();
        double output = 1.0;
        for (Map.Entry<Ingredient, Integer> targetEntry : List.copyOf(target.entrySet())) {
            Ingredient ingredient = targetEntry.getKey();
            Pair<Integer, @Nullable Double> matchResult = BrewingStepUtil.computeScoreAndAmount(ingredient, modifiedActual, target, targetEntry.getValue());
            if (matchResult.first() == 0) {
                return 0.0;
            }
            Double score = matchResult.second();
            if (score != null) {
                ingredientScoreCumulativeSum += score * (double)matchResult.first().intValue();
                scoredIngredientAmount += matchResult.first().intValue();
            }
            output *= BrewingStepUtil.nearbyValueScore(targetEntry.getValue().intValue(), matchResult.first().intValue());
        }
        if (!modifiedActual.isEmpty()) {
            return 0.0;
        }
        double ingredientScore = ingredientScoreCumulativeSum > 0.0 ? ingredientScoreCumulativeSum / (double)scoredIngredientAmount : 1.0;
        return output * ingredientScore;
    }

    private static Pair<Integer, @Nullable Double> computeScoreAndAmount(Ingredient ingredient, Map<BaseIngredient, Integer> actual, Map<Ingredient, Integer> target, int targetAmount) {
        if (ingredient instanceof IngredientGroup) {
            IngredientGroup ingredientGroup = (IngredientGroup)ingredient;
            return BrewingStepUtil.computeIngredientGroupMatch(ingredientGroup, actual, target, targetAmount);
        }
        Optional<? extends Ingredient> ingredientMatchOptional = ingredient.findMatch(actual.keySet());
        if (ingredientMatchOptional.isPresent()) {
            Ingredient ingredientMatch = ingredientMatchOptional.get();
            int amount = actual.remove(ingredientMatch.toBaseIngredient());
            return new Pair<Integer, Double>(amount, IngredientUtil.score(ingredientMatch).orElse(null));
        }
        return new Pair<Integer, Object>(0, null);
    }

    private static Pair<Integer, @Nullable Double> computeIngredientGroupMatch(IngredientGroup ingredientGroup, Map<BaseIngredient, Integer> actual, Map<Ingredient, Integer> target, int targetAmount) {
        IngredientWithMeta ingredientWithMeta;
        Double score;
        int ingredientAmount = 0;
        double ingredientScoreSum = 0.0;
        int amountOfScoredIngredients = 0;
        ArrayList<Ingredient> postProcess = new ArrayList<Ingredient>();
        for (Ingredient ingredient : ingredientGroup.alternatives()) {
            Ingredient ingredientMatch;
            BaseIngredient baseIngredient;
            Optional<? extends Ingredient> optionalIngredient = ingredient.findMatch(actual.keySet());
            if (optionalIngredient.isEmpty() || !actual.containsKey(baseIngredient = (ingredientMatch = optionalIngredient.get()).toBaseIngredient())) continue;
            if (ingredientMatch instanceof IngredientWithMeta && (score = (ingredientWithMeta = (IngredientWithMeta)ingredientMatch).get(IngredientMeta.SCORE)) != null) {
                int amount = actual.get(baseIngredient);
                ingredientScoreSum += score * (double)amount;
                amountOfScoredIngredients += amount;
            }
            if (target.containsKey(ingredient)) {
                postProcess.add(ingredient);
                continue;
            }
            ingredientAmount += actual.remove(baseIngredient).intValue();
        }
        for (Ingredient ingredient : postProcess) {
            Double d;
            if (targetAmount <= ingredientAmount) break;
            BaseIngredient baseIngredient = ingredient.toBaseIngredient();
            int amount = actual.getOrDefault(baseIngredient, 0);
            int increase = Math.min(amount, targetAmount - ingredientAmount);
            if (ingredient instanceof IngredientWithMeta && (d = (ingredientWithMeta = (IngredientWithMeta)ingredient).get(IngredientMeta.SCORE)) instanceof Double) {
                score = d;
                ingredientScoreSum += score * (double)increase;
                amountOfScoredIngredients += increase;
            }
            ingredientAmount += increase;
            if (amount == increase) {
                actual.remove(baseIngredient);
                continue;
            }
            actual.put(baseIngredient, amount - increase);
        }
        return new Pair<Integer, Object>(ingredientAmount, (amountOfScoredIngredients == 0 ? null : Double.valueOf(ingredientScoreSum / (double)amountOfScoredIngredients)));
    }
}

