/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.brew;

import dev.jsinco.brewery.api.brew.BrewingStep;
import dev.jsinco.brewery.api.brew.PartialBrewScore;
import dev.jsinco.brewery.api.brew.ScoreType;
import dev.jsinco.brewery.api.breweries.BarrelType;
import dev.jsinco.brewery.api.moment.Moment;
import dev.jsinco.brewery.brew.BrewingStepUtil;
import dev.jsinco.brewery.configuration.Config;
import dev.jsinco.brewery.util.CollectionUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedCollection;
import java.util.SequencedSet;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public record AgeStepImpl(Moment time, BarrelType barrelType, SequencedSet<UUID> brewers) implements BrewingStep.Age
{
    private static final Map<ScoreType, PartialBrewScore> BREW_STEP_MISMATCH = Stream.of(new PartialBrewScore(0.0, ScoreType.TIME), new PartialBrewScore(0.0, ScoreType.BARREL_TYPE)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));

    public AgeStepImpl(Moment time, BarrelType barrelType) {
        this(time, barrelType, Collections.emptySortedSet());
    }

    @Override
    public AgeStepImpl withAge(Moment age) {
        return new AgeStepImpl(age, this.barrelType, this.brewers);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<ScoreType, PartialBrewScore> proximityScores(BrewingStep other) {
        Moment otherAge;
        SequencedSet<UUID> sequencedSet;
        if (!(other instanceof AgeStepImpl)) return BREW_STEP_MISMATCH;
        AgeStepImpl ageStepImpl = (AgeStepImpl)other;
        try {
            sequencedSet = ageStepImpl.time();
            otherAge = sequencedSet;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> otherType = sequencedSet = ageStepImpl.barrelType();
        SequencedSet<UUID> ignored = sequencedSet = ageStepImpl.brewers();
        double barrelTypeScore = this.barrelType.equals(BarrelType.ANY) || this.barrelType.equals(otherType) ? 1.0 : 0.9;
        return Stream.of(new PartialBrewScore(Math.sqrt(BrewingStepUtil.nearbyValueScore(this.time.moment(), otherAge.moment())), ScoreType.TIME), new PartialBrewScore(barrelTypeScore, ScoreType.BARREL_TYPE)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public BrewingStep.StepType stepType() {
        return BrewingStep.StepType.AGE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Map<ScoreType, PartialBrewScore> maximumScores(BrewingStep other) {
        Moment otherAge;
        SequencedSet<UUID> sequencedSet;
        if (!(other instanceof AgeStepImpl)) return BREW_STEP_MISMATCH;
        AgeStepImpl ageStepImpl = (AgeStepImpl)other;
        try {
            sequencedSet = ageStepImpl.time();
            otherAge = sequencedSet;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> otherType = sequencedSet = ageStepImpl.barrelType();
        SequencedSet<UUID> ignored = sequencedSet = ageStepImpl.brewers();
        double barrelTypeScore = this.barrelType.equals(BarrelType.ANY) || this.barrelType.equals(otherType) ? 1.0 : 0.9;
        double timeScore = otherAge.moment() < this.time.moment() ? 1.0 : BrewingStepUtil.nearbyValueScore(this.time.moment(), otherAge.moment());
        return Stream.of(new PartialBrewScore(timeScore, ScoreType.TIME), new PartialBrewScore(barrelTypeScore, ScoreType.BARREL_TYPE)).collect(Collectors.toUnmodifiableMap(PartialBrewScore::type, partial -> partial));
    }

    @Override
    public Map<ScoreType, PartialBrewScore> failedScores() {
        return BREW_STEP_MISMATCH;
    }

    @Override
    public boolean isCompleted() {
        return this.time().moment() > Config.config().barrels().agingYearTicks() / 2L;
    }

    @Override
    public BrewingStep.Age withBrewersReplaced(SequencedCollection<UUID> brewers) {
        return new AgeStepImpl(this.time, this.barrelType, new LinkedHashSet<UUID>(brewers));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Moment otherTime;
        SequencedSet<UUID> sequencedSet;
        if (!(o instanceof AgeStepImpl)) return false;
        AgeStepImpl ageStepImpl = (AgeStepImpl)o;
        try {
            sequencedSet = ageStepImpl.time();
            otherTime = sequencedSet;
        }
        catch (Throwable throwable) {
            throw new MatchException(throwable.toString(), throwable);
        }
        SequencedSet<UUID> otherType = sequencedSet = ageStepImpl.barrelType();
        SequencedSet<UUID> otherBrewers = sequencedSet = ageStepImpl.brewers();
        if (!Objects.equals(this.time, otherTime)) return false;
        if (this.barrelType != otherType) return false;
        if (!CollectionUtil.isEqualWithOrdering(this.brewers, otherBrewers)) return false;
        return true;
    }
}

