/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.serialize;

import com.google.common.base.Preconditions;
import java.util.function.Function;
import java.util.function.Predicate;

public interface Serializer<T> {
    public T deserialize(String var1);

    public String serializeSafely(T var1);

    default public String serialize(Object object) throws IllegalArgumentException {
        Preconditions.checkArgument((boolean)this.appliesTo(object), (Object)("Invalid deserialization object: " + String.valueOf(object)));
        return this.serializeSafely(object);
    }

    public boolean appliesTo(Object var1);

    public static <T> Serializer<T> compile(final Function<T, String> serialize, final Function<String, T> deserialize, final Predicate<Object> appliesTo) {
        return new Serializer<T>(){

            @Override
            public T deserialize(String serialized) {
                return deserialize.apply(serialized);
            }

            @Override
            public String serializeSafely(T deserialized) {
                return (String)serialize.apply(deserialized);
            }

            @Override
            public boolean appliesTo(Object object) {
                return appliesTo.test(object);
            }
        };
    }

    public static <U, G> Serializer<U> fork(final Function<U, G> toComplex, final Function<G, U> toSimple, final Predicate<Object> appliesTo, final Serializer<G> parent) {
        return new Serializer<U>(){

            @Override
            public U deserialize(String serialized) {
                return toSimple.apply(parent.deserialize(serialized));
            }

            @Override
            public String serializeSafely(U deserialized) {
                return parent.serializeSafely(toComplex.apply(deserialized));
            }

            @Override
            public boolean appliesTo(Object object) {
                return appliesTo.test(object);
            }
        };
    }

    public static class StringMetaSerializer
    implements Serializer<String> {
        @Override
        public String deserialize(String serialized) {
            return serialized;
        }

        @Override
        public String serializeSafely(String deserialized) {
            return "\"" + deserialized.replace("\\", "\\\\").replace("\"", "\\\"") + "\"";
        }

        @Override
        public boolean appliesTo(Object object) {
            return object instanceof String;
        }
    }
}

