/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.meta;

import com.google.common.collect.Lists;
import dev.jsinco.brewery.api.meta.MetaDataType;
import java.util.List;

public class ListMetaDataType<P, C>
implements MetaDataType<List<P>, List<C>> {
    public static final int MAX_DEPTH = 10;
    private final MetaDataType<P, C> elementType;

    private ListMetaDataType(MetaDataType<P, C> elementType) {
        this.elementType = elementType;
    }

    public static <P, C> ListMetaDataType<P, C> from(MetaDataType<P, C> elementType) {
        if (ListMetaDataType.isTooDeeplyNested(elementType, 0)) {
            throw new IllegalArgumentException("Element type too deeply nested: " + String.valueOf(elementType));
        }
        return new ListMetaDataType<P, C>(elementType);
    }

    private static boolean isTooDeeplyNested(MetaDataType<?, ?> elementType, int depth) {
        if (depth > 10) {
            return true;
        }
        if (elementType instanceof ListMetaDataType) {
            ListMetaDataType nestedListType = (ListMetaDataType)elementType;
            return ListMetaDataType.isTooDeeplyNested(nestedListType.elementType, depth + 1);
        }
        return false;
    }

    @Override
    public Class<List<P>> getPrimitiveType() {
        return List.class;
    }

    @Override
    public Class<List<C>> getComplexType() {
        return List.class;
    }

    @Override
    public List<P> toPrimitive(List<C> complex) {
        return Lists.transform(complex, this.elementType::toPrimitive);
    }

    @Override
    public List<C> toComplex(List<P> primitive) {
        return Lists.transform(primitive, this.elementType::toComplex);
    }

    public MetaDataType<P, C> getElementDataType() {
        return this.elementType;
    }
}

