/*
 * Decompiled with CFR 0.152.
 */
package dev.jsinco.brewery.api.ingredient;

import com.google.common.base.Preconditions;
import dev.jsinco.brewery.api.ingredient.BaseIngredient;
import dev.jsinco.brewery.api.ingredient.Ingredient;
import dev.jsinco.brewery.api.ingredient.IngredientMeta;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public record IngredientWithMeta(Ingredient ingredient, Map<IngredientMeta<?>, Object> meta) implements Ingredient
{
    public IngredientWithMeta {
        for (Map.Entry<IngredientMeta<?>, Object> entry : meta.entrySet()) {
            Preconditions.checkArgument((boolean)entry.getKey().serializer().appliesTo(entry.getValue()), (Object)("Invalid meta ingredient data '" + entry.getKey().key().minimalized() + "' for: " + String.valueOf(entry.getValue())));
        }
    }

    @Override
    @NotNull
    public String getKey() {
        return this.ingredient.getKey();
    }

    @Override
    @NotNull
    public Component displayName() {
        Component override = this.get(IngredientMeta.DISPLAY_NAME);
        if (override == null) {
            return this.ingredient.displayName();
        }
        return override;
    }

    @Override
    public Optional<? extends Ingredient> findMatch(Set<BaseIngredient> baseIngredientSet) {
        return this.ingredient.findMatch(baseIngredientSet).map(this::applyTo);
    }

    @Override
    public BaseIngredient toBaseIngredient() {
        return this.ingredient.toBaseIngredient();
    }

    public IngredientWithMeta applyTo(Ingredient ingredient) {
        return new IngredientWithMeta(ingredient, this.meta);
    }

    @Nullable
    public <T> T get(IngredientMeta<T> metaKey) {
        return (T)this.meta.get(metaKey);
    }
}

